#
# Copyright (C) 1999  Motoyuki Kasahara
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

# version
source version.tcl

# pkgdatadir
set pkgdatadir "C:\\Program Files\\BookView"

# srcdir
set srcdir [file dirname $argv0]

# error_message
set error_message ""

# Files to be installed.
set install_files {
    "bookview/bookview.tcl"
    "bookview/finder.tcl"
    "bookview/message.tcl"
    "bookview/ndtp.tcl"
    "bookview/help.tcl"
    "bookview/setup.tcl"
    "bookview/ja.mo.win32"
    "bitmap/arrow.xbm"
    "bitmap/backward.xbm"
    "bitmap/copyright.gif"
    "bitmap/find.gif"
    "bitmap/forward.xbm"
    "bitmap/menu.gif"
    "bitmap/next.gif"
    "bitmap/prev.gif"
    "bitmap/space.xbm"
    "doc/help.txt"
    "doc-ja/help-ja.txt"
}

set button_flag ""

#
# Make a window.
#
proc make_main_window {} {
    global button_flag
    global pkgdatadir

    #
    # Set window title.
    #
    wm title . "BookView Tiny Installer for Windows"

    #
    # Install prefix.
    #
    frame .pkgdatadir
    pack .pkgdatadir -side top -expand 1 -fill x -padx 4 -pady 4
    label .pkgdatadir.label -text "Install Directory: "
    pack .pkgdatadir.label -side left
    entry .pkgdatadir.entry -textvariable pkgdatadir -width 40
    pack .pkgdatadir.entry -side left -expand 1 -fill x
    bind .pkgdatadir.entry <Return> {set button_flag "exit"}

    #
    # Buttons.
    #
    frame .buttons
    pack .buttons -side top -expand 1 -fill x -padx 4 -pady 4
    button .buttons.install -text "Install" -default active \
	    -command {set button_flag "install"}
    pack .buttons.install -side left -expand 1
    button .buttons.exit -text "Exit" \
	    -command {set button_flag "exit"}
    pack .buttons.exit -side left -expand 1

    #
    # Wait until an user clicks a button.
    #
    tkwait variable button_flag
    if {$button_flag == "exit"} {
	destroy .
	exit
    }
}

#
# Generate `bookview/bookview.tcl' from `bookview/bookview.in'.
#
proc generate_bookview_tcl {} {
    global srcdir
    global version
    global pkgdatadir
    global error_message

    file delete -force "$srcdir/bookview/bookview.tcl"
    if {[catch {set rfile [open "$srcdir/bookview/bookview.in" "r"]} \
	    error_message]} {
	return 0
    }
    if {[catch {set wfile [open "$srcdir/bookview/bookview.tcl" "w"]} \
	    error_message]} {
	catch {close $rfile}
	return 0
    }
    while {1} {
	if {[catch {gets $rfile line} error_message]} {
	    catch {close $rfile}
	    catch {close $wfile}
	    return 0
	}
	regsub -all {@VERSION@} $line $version line
	regsub -all {@pkgdatadir@} $line $pkgdatadir line
	if {[catch {puts $wfile $line} error_message]} {
	    catch {close $rfile}
	    catch {close $wfile}
	    return 0
	}
	if {[eof $rfile]} {
	    break
	}
    }
    catch {close $rfile}
    catch {close $wfile}

    return 1
}

#
# Generate `bookview/ja.mo.win32' from `bookview/ja.mo'.
#
proc generate_ja_mo_win32 {} {
    global srcdir
    global version
    global pkgdatadir
    global error_message

    file delete -force "$srcdir/bookview/ja.mo.win"
    if {[catch {set rfile [open "$srcdir/bookview/ja.mo" "r"]} \
	    error_message]} {
	return 0
    }
    fconfigure $rfile -encoding euc-jp

    if {[catch {set wfile [open "$srcdir/bookview/ja.mo.win32" "w"]} \
	    error_message]} {
	catch {close $rfile}
	return 0
    }
    
    while {1} {
	if {[catch {gets $rfile line} error_message]} {
	    catch {close $rfile}
	    catch {close $wfile}
	    return 0
	}
	if {[catch {puts $wfile $line} error_message]} {
	    catch {close $rfile}
	    catch {close $wfile}
	    return 0
	}
	if {[eof $rfile]} {
	    break
	}
    }
    catch {close $rfile}
    catch {close $wfile}

    return 1
}

#
# Make the directory $pkgdatadir.
#
proc create_pkgdatadir {} {
    global pkgdatadir
    global error_message

    if {![file isdirectory $pkgdatadir]} {
	if {[catch {file mkdir $pkgdatadir} error_message]} {
	    return 0
	}
    }

    return 1
}

#
# Install files.
#
proc install_files {} {
    global srcdir
    global pkgdatadir
    global install_files
    global error_message

    foreach src $install_files {
	set dst "$pkgdatadir/[file tail $src]"
	regsub {\.win32$} $dst {} dst
	if {[catch {file copy -force $srcdir/$src $dst} error_message]} {
	    return 0
	}
    }

    return 1
}

#
# Make a result window.
#
proc make_result_window {message} {
    global button_flag

    toplevel .result
    set x [expr [winfo rootx .] + 24]
    set y [expr [winfo rooty .] + 24]
    wm geometry .result +$x+$y
    focus .result
    grab .result

    #
    # Message.
    #
    frame .result.message
    pack .result.message -side top -expand 1 -fill x -padx 4 -pady 4
    message .result.message.message -text $message -width 40c
    pack .result.message.message -side top -expand 1 -fill x

    #
    # Buttons.
    #
    frame .result.buttons
    pack .result.buttons -side top -expand 1 -fill x -padx 4 -pady 4
    button .result.buttons.exit -text "Exit" -default active \
	    -command {set button_flag "exit"}
    pack .result.buttons.exit -side top -expand 1 -fill x

    bind .result <Return> {set button_flag "exit"}

    #
    # Wait until an user clicks a button.
    #
    tkwait variable button_flag
    destroy .
}

#
# Main.
#
make_main_window
regsub -all "\\\\" $pkgdatadir "/" pkgdatadir

if {![generate_bookview_tcl]} {
    make_result_window $error_message
    exit 1
}
if {![generate_ja_mo_win32]} {
    make_result_window $error_message
    exit 1
}
if {![create_pkgdatadir]} {
    make_result_window $error_message
    exit 1
}
if {![install_files]} {
    make_result_window $error_message
    exit 1
}

make_result_window "Done."
exit 0

