#!/bin/sh

workdir=`pwd`

# Check the version of FreeBSD
check_version()
{
    RELVER=`uname -r`

    NUMVER=`echo $RELVER|sed "s/-.*//"`
    MAJVER=`echo $NUMVER|sed "s/\..*//"`
    if [ $NUMVER = $MAJVER ] ; then
	MINVER=0
    else
	SUBVER=`echo $NUMVER |sed "s/.*\.//"`
	if [ $NUMVER = "$MAJVER.$SUBVER" ] ; then
	    MINVER=$SUBVER
	    SUBVER=0
	else
	    MINVER=`echo $RELVER|sed "s/\.$SUBVER\-.*//"|sed "s/.*\.//"`
	fi
    fi

    # >5.x
    if [ $MAJVER -gt 5  ] ; then
	safe_sendfile=1
	return
    fi
    # >=5.2
    if [ $MAJVER -eq 5 -a $MINVER -ge 2 ] ; then
	safe_sendfile=1
	return
    fi
    # >4.9
    if [ $MAJVER -eq 4 -a \( $MINVER -gt 9 -o $MINVER -eq 9 -a $SUBVER -gt 0 \) ] ; then
	safe_sendfile=1
	return
    fi

    safe_sendfile=0
}

case "$1" in
FreeBSD)
    $0 clean
    cd $workdir
    ln -s Makefile.FreeBSD Makefile
    cd $workdir/ftp
    ln -s Makefile.FreeBSD Makefile
    cd $workdir/ftpd
    ln -s Makefile.FreeBSD Makefile
    case "$2" in
	sendfile)
	    echo "CFLAGS+=-DUSE_SENDFILE">>Makefile.inc
	    ;;
	nosendfile)
	    ;;
	*)
	    check_version
	    if [ $safe_sendfile -eq 1 ] ; then
		echo "CFLAGS+=-DUSE_SENDFILE">>Makefile.inc
	    fi
	    ;;
    esac
    cd $workdir/port/libbsdport
    ln -s Makefile.FreeBSD Makefile
    cd $workdir/port/libedit
    ln -s Makefile.FreeBSD Makefile
    # make symlinks to headers
    cd $workdir/port
    ln -s ../contrib/libedit/histedit.h histedit.h
    ;;
Linux)
    $0 clean
    cd $workdir
    ln -s Makefile.linux Makefile
    touch Makefile.inc
    cd $workdir/ftp
    ln -s Makefile.linux Makefile
    cd $workdir/ftpd
    case "$2" in
	NOPAM)
	    ln -s Makefile.linux-shadow Makefile
	    ;;
	Kerberos)
	    echo "CFLAGS+= -I/usr/kerberos/include">>../Makefile.inc
	    ln -s Makefile.linux Makefile
	    ;;
	*)
	    ln -s Makefile.linux Makefile
	    ;;
    esac
    cd $workdir/port/libbsdport
    ln -s Makefile.linux Makefile
    cd $workdir/port/libedit
    ln -s Makefile.linux Makefile
    touch Makefile.inc
    case "$2" in
	noncursesdir)
	    echo "CFLAGS+= -DNONCURSESDIR">>Makefile.inc
	    ;;
    esac
    # make symlinks to headers
    cd $workdir/port
    ln -s ../contrib/libbsdport/include/glob.h bsdglob.h
    ln -s ../contrib/libbsdport/include/fts.h bsdfts.h
    ln -s ../contrib/libbsdport/include/stringlist.h stringlist.h
    ln -s ../contrib/libbsdport/libutil/libutil.h libutil.h
    ln -s ../contrib/libedit/histedit.h histedit.h
    ;;
clean)
    cd $workdir
    rm -f Makefile
    rm -f Makefile.inc
    rm -f $workdir/ftpd/Makefile
    rm -f $workdir/ftpd/Makefile.inc
    rm -f $workdir/ftp/Makefile
    rm -f $workdir/port/libbsdport/Makefile
    rm -f $workdir/port/libedit/Makefile
    rm -f $workdir/port/libedit/Makefile.inc
    rm -f $workdir/port/bsdglob.h
    rm -f $workdir/port/bsdfts.h
    rm -f $workdir/port/stringlist.h
    rm -f $workdir/port/libutil.h
    rm -f $workdir/port/histedit.h
    ;;
"")
    echo "usage:"
    echo "  config.sh OS [OSFeature]"
    echo "    where \"OS\" is a name of the target operating system, currently"
    echo "    \"FreeBSD\" or \"Linux\". \"OSFeature\" may be used in addition"
    echo "    to \"OS\" to enable the support for some specific features of"
    echo "    \"OS\". Currently the possible values of \"OSFeature\" are:"
    echo "    \"NOPAM\", \"Kerberos\", \"noncursesdir\", \"sendfile\" and"
    echo "    \"nosendfile\"."
    echo "  config.sh clean"
    echo "    to cleanup OS dependencies."
    ;;
*)
    echo "OS \"$1\" not supported"
    ;;
esac
