/* linuxport.h    - Linux porting things */
/*-
 * Copyright (c) 2002, 2003 Nick Leuta
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef	_LINUXPORT_H_
#define	_LINUXPORT_H_

/*	from sys/param.h
 * MAXLOGNAME should be == UT_NAMESIZE+1 (see <utmp.h>)
 */
/* #define MAXLOGNAME 17 */ /* in FreeBSD 4.x */
/* #define MAXLOGNAME 33 */ /* in Linux/Glibc-2.2 */
/* We can't include <utmp.h>, because some its functions may have the same
 * names as another functions in FTP client. So we can to use the value
 * of UT_NAMESIZE like in examples above or to try next way (it works at least
 * with Glibc 2.2) */
#ifndef _UTMP_H
# define _UTMP_H
# include <bits/utmp.h>
# undef _UTMP_H
#endif
#define MAXLOGNAME UT_NAMESIZE+1

/*	from stdio.h
 */
int	 asprintf __P((char **, const char *, ...));
char	*fgetln __P((FILE *, size_t *));

/*	from stdlib.h
 */
void    *reallocf(void *, size_t);

/*	from string.h
 */
size_t	 strlcpy(char *, const char *, size_t);

/*	from netdb.h
 */
struct hostent	*getipnodebyaddr __P((const void *, size_t, int, int *));
void		freehostent __P((struct hostent *));

/*	from sys/select.h
 */
#define	FD_COPY(f, t)	(void)(*(t) = *(f))

/*
 * Special porting things
 */
#define AI_ADDRLEN(HI) \
    HI->ai_addrlen - (HI->ai_family == AF_INET ? \
    sizeof(struct sockaddr) - __SOCKADDR_COMMON_SIZE - sizeof (in_port_t) - \
    sizeof(struct in_addr) : 0)

#endif /* !_LINUXPORT_H_ */
