{- call to assert fails -}

module Main where

data Tree a = Nil | Node a (Tree a) (Tree a)
              deriving Show

treeFromList :: Ord a => [a] -> Tree a
treeFromList = foldr insertInTree Nil 

insertInTree :: Ord a => a -> Tree a -> Tree a
insertInTree x Nil = Nil 
insertInTree x (Node y l r)
   | x > y = insertInTree x r
   | otherwise = insertInTree x l

mirror :: Tree a -> Tree a
mirror tree 
   = assert ((not . empty) tree) (mirror' tree)
   where
   empty :: Tree a -> Bool
   empty Nil = True 
   empty _   = False 
 
mirror' :: Tree a -> Tree a
mirror' (Node x l r) = Node x (mirror' r) (mirror' l)

main :: IO ()
main = do putStrLn "Type some input:" 
          line <- getLine 
          print $ mirror $ treeFromList line
          putStrLn "The End" 

assert :: Bool -> a -> a
assert False x = error "assertion failed"
assert True  x = x
