module Main where

import IO (stdout, hSetBuffering, BufferMode (NoBuffering))

default ()

data Tree a = Empty | Node a (Tree a) (Tree a)
              

main :: IO ()
main = do hSetBuffering stdout NoBuffering
          treeWalk (buildTree ([3,6,9,2,-1,0,18]::[Int])) []

buildTree :: Ord a => [a] -> Tree a
buildTree = foldr insert Empty

insert :: Ord a => a -> Tree a -> Tree a
insert x Empty = Node x Empty Empty
insert x (Node y l r)
   | x <= y = Node y (insert x l) r
   | otherwise = Node y l (insert x r)

treeWalk :: Show a => Tree a -> [Tree a] -> IO ()
treeWalk tree hist
   = do putStrLn (labelOutput tree)
        handleCommand tree hist

labelOutput :: Show a => Tree a -> String
labelOutput Empty        = "Empty tree"
labelOutput (Node l _ _) = "Label:  " ++ show l

prompt :: Tree a -> [Tree a] -> String
prompt Empty [] = ""
prompt Empty _  = "(u)p"
prompt _     [] = "(l)eft, (r)ight,"
prompt _     _  = "(l)eft, (r)ight, (u)p,"

handleCommand :: Show a => Tree a -> [Tree a] -> IO ()
handleCommand tree hist
   = do putStr ("Command " ++ (prompt tree hist) ++ " or (q)uit: ")
        line <- getLine
        case line of
           'l':_ -> left tree hist
           'r':_ -> right tree hist
           'u':_ -> up tree hist
           'q':_ -> return ()
           _     -> invalidCommand tree hist

left,right,up :: Show a => Tree a -> [Tree a] -> IO ()

-- left Empty             hist = inappropriateCommand "left" Empty hist
left tree@(Node _ l _) hist = treeWalk l (tree:hist)

right Empty             hist = inappropriateCommand "right" Empty hist
right tree@(Node _ _ r) hist = treeWalk r (tree:hist)

up tree []        = inappropriateCommand "up" tree []
up _    (tree:hist) = treeWalk tree hist

invalidCommand :: Show a => Tree a -> [Tree a] -> IO ()
invalidCommand tree hist
   = do putStrLn "Invalid command!"
        handleCommand tree hist

inappropriateCommand :: Show a => String -> Tree a -> [Tree a] -> IO ()
inappropriateCommand direction tree hist
   = do putStrLn ("Can't go " ++ direction ++ " now")
        handleCommand tree hist
