module Utils where

import Types

default ()

{- True iff the left and right brackets pair up correctly in string -}
matchingBrackets :: String -> Bool
matchingBrackets str = match str (0::Int)
    where
    match "" open = (open == 0) -- good match iff no open brackets
    match (x:xs) open 
       | open < 0 = False       -- if we ever get more ')' than '(', bad match
       | x == '(' = match xs (open + 1)
       | x == ')' = match xs (open - 1)
       | otherwise = match xs open

{- given a list with at least one duplicate, find a duplicate; 
   if no dups return Nothing -}
findDuplicate :: Eq a => [a] -> Maybe a
findDuplicate [] = Nothing
findDuplicate (x:xs) | x `elem` xs = Just x
                     | otherwise   = findDuplicate xs

{- take a number and a (singular) noun; return the string with the number and
   the noun and if the number /= 1, add an "s" (pluralise) to the end of it -}
pluralise :: Num a => a -> String -> String
pluralise 1 noun = "1 " ++ noun
pluralise n noun = show n ++ " " ++ noun ++ "s"

{- general error message when function calls exist with wrong arity -}
arityComplaint :: FunName -> Arity -> Arity -> String
arityComplaint fun expected encountered
    = "Call doesn't respect arity of function " ++ fun
      ++ " (namely, " ++ pluralise expected "argument" 
      ++ "),\nwhich was called here with " 
      ++ pluralise encountered  "argument" 
