module GeneticAlgorithm where

import Types
import Basics
import CPU
import Random
import Monad (zipWithM)
import System (system)

type Agent = [Weight] -- assumption that agents are going to all have the same size,
                       -- this isn't verified at any stage though
type Bound = (Weight, Weight)

do_all :: IO ()
do_all
    = do
      let basicPlayer = magicNums simple
          bounds = repeat (0,100)
          popSize = 10
      mutated <- mapM (mutate 3 bounds) $ replicate popSize basicPlayer
      let startingPopulation = [[1000,99,23,10,100000,41,2,78,84,12,83,45,94,21,32,22],[1000,99,15,10,100000,41,2,78,84,96,83,45,94,98,32,22],[1000,99,23,10,100000,41,2,78,84,96,83,45,94,21,32,78],[1000,99,23,10,100000,41,2,78,84,96,83,45,94,21,32,78],[1000,99,15,10,100000,41,2,78,84,12,83,45,94,21,32,22],[1000,99,23,10,100000,41,2,78,84,96,83,45,94,98,32,22],[1000,99,23,10,100000,41,2,78,84,96,83,45,94,98,32,22],[62,99,15,10,100000,41,2,78,84,12,83,3,94,98,32,22],[1000,99,23,35,90,41,2,78,84,96,83,45,94,21,32,78],[1000,99,23,10,89,41,70,78,84,96,83,45,94,21,32,22]] -- mutated

      do_genetic_alg 100 bounds startingPopulation >> return ()



do_genetic_alg :: Int -> [Bound] -> [Agent] -> IO [Agent]
do_genetic_alg 0    _      pop       = return pop
do_genetic_alg gens bounds start_pop
    = do 
      system "date"
      putStrLn $ "GA: Generations to go = " ++ show gens

      agent_scores <- assignFitnesses start_pop


      let bestAgents = map fst $ sortByFun (((-1) *) . snd) agent_scores
          pop_size = length start_pop
          (best_ones, rest) = splitAt (pop_size `div` 3) bestAgents

      xys <- zipWithM (crossover 2) best_ones (reverse best_ones)

      let crossed_over = map fst xys ++ map snd xys

      mutated <- mapM (mutate 2 bounds) best_ones

      let nextGen = take (pop_size) (mutated ++ crossed_over ++ rest)

      putStrLn "GA: Best so far"
      print bestAgents
      do_genetic_alg (gens - 1) bounds nextGen



      


assignFitnesses :: [Agent] -> IO [(Agent, Float)]
assignFitnesses agents
    = loop agents
    where
    loop [] = return []
    loop (ag:rest)
        = do 
          putStrLn "  GA: assigning fitness for one agent"
          xys <- mapM (getScores ag) agents  -- this is rather lazy: we just ignore how the other agent goes in these games
          res <- loop rest
          let this_agent_score = sum (map fst xys)
          return $ (ag, this_agent_score):res
                                         
      

makeRandomMoves :: Int -> Game -> IO Game
makeRandomMoves 0 game = return game
makeRandomMoves num game
    = do 
      let moves = legalMoves game
          len = length moves
      randNum <- rand 0 (len - 1)
      let moveChosen = moves !! randNum
      makeRandomMoves (num - 1) (makeMove moveChosen game)


getScores :: Agent -> Agent -> IO (Float, Float)
getScores agent1 agent2 
    = do
      putStrLn "    GA: playing two games"
      let player1 = simple { magicNums = agent1, chooseSearchDepth = const 2 }
      let player2 = player1 { magicNums = agent2 }
      game <- makeRandomMoves 4 newGame 
      (p1score, p2score) <- playGame game player1 player2
      (p2score', p1score') <- playGame game player2 player1
      let scores = (p1score + p1score', p2score + p2score')
      putStrLn $ "    GA: scores as a result " ++ show scores
      return scores

-- assign each player some points for their performance in the game
playGame :: Game -> CPUPrefs -> CPUPrefs -> IO (Float, Float)
playGame game player1 player2
    = if numMoves game >= 140 
      then let p1 = fromIntegral $ length $ filter (stillOnBoard game) $ map (\s -> (White, s)) allSpecies
               p2 = fromIntegral $ length $ filter (stillOnBoard game) $ map (\s -> (Black, s)) allSpecies
           in return (p1 / 100, p2 / 100)  -- slight favourite is the player with more pieces
      else if properLastMoveWin game 
           then return (if whoseTurn game == White then (0,5) else (5,0))
           else do
                move <- getCPUMove game $ if whoseTurn game == White then player1 else player2
                let newGame = makeMove move game
                playGame newGame player1 player2

               





-- this isn't strictly the usual multipleCrossovers function,
-- but it's easier to define in terms of multiple attempts at single crossovers :)
crossover :: Int -> Agent -> Agent -> IO (Agent, Agent)
crossover 0 x y = return (x,y)
crossover iter mummy daddy
    = do
      (x,y) <- singleCrossover mummy daddy
      crossover (iter - 1) x y


mutate :: Int -> [Bound] -> Agent -> IO Agent
mutate 0 _ x = return x
mutate numberChanges bounds agent
    = do
      newAgent <- singleMutate bounds agent
      mutate (numberChanges - 1) bounds newAgent




singleMutate :: [Bound] -> Agent -> IO Agent
singleMutate bounds agent 
    = do 
      let len = length agent
      mutatePoint <- rand 0 (len - 1)
      let (lower, upper) = bounds !! mutatePoint
      newVal <- rand lower upper
      return (take mutatePoint agent ++ [newVal] ++ drop (mutatePoint + 1) agent)

singleCrossover :: Agent -> Agent -> IO (Agent, Agent)
singleCrossover mummy daddy
    = do
      let len = length mummy
      crossPoint <- rand 0 (len - 1)
      let child1 = take crossPoint mummy ++ drop crossPoint daddy
      let child2 = take crossPoint daddy ++ drop crossPoint mummy
      return (child1, child2)
          


-- rand takes a range and returns an integer
rand :: Weight -> Weight -> IO Weight
rand low high =
    do f <- getStdRandom (randomR (low, high))
       return f

