module Main where

import Types
import Basics 
import CPU 
import PosEval
import ParseLib
import Char(toLower)
-- import IOExts(unsafePerformIO)
import System(getArgs)
import GeneticAlgorithm

g1 :: Game
g1 = setupPosition [((White, Mouse), (1,1)),
                    ((Black, Mouse), (1,5))] Black

defaultInfo :: GameInfo
defaultInfo = Info { player = player' }
              where player' White = Human
                    player' Black = CPU simple 


main :: IO ()
main = flip const GeneticAlgorithm.do_all normal_loop
    where
    normal_loop = 
       if False then
           print (const g1 recovered)  -- so that these can be in scope without 'unused variable' errors
       else
           do 
           args <- getArgs 
           case args of 
                ["human"] -> loop newGame (defaultInfo { player = const Human })
                _ -> loop newGame defaultInfo
                



persistentBackup, defaultFileName :: FilePath
persistentBackup = "games/lastGame"
defaultFileName  = "games/default"


data Cmd = MakeMove Move | Cmd String

{- so that you can Ctrl-C during game and get the info -}
recover :: IO Game
recover = loadGame persistentBackup

recovered :: Game
-- recovered = unsafePerformIO recover
recovered = undefined 


loop :: Game -> GameInfo -> IO ()
loop game info
    = do
      print info
      print game
      let cpuprefs = simple
      print (nonMonadicPosEval cpuprefs game White)

      cmd <- case (player info) (whoseTurn game) of
                  Human -> getHumanCmd
                  CPU p -> liftM MakeMove (getCPUMove game p)

      case cmd of 
           MakeMove move ->
              if not (legalMove game move) then
                 putStrLn "Not legal!" >> loop game info
                 else 
                     let game' = makeMove move game in
                     if properLastMoveWin game' then do print game
                                                        putStrLn "----------"
                                                        putStrLn "Game over!"
                                                        putStrLn "----------"
                                                        loop newGame info
                     else do saveGame persistentBackup game
                             loop game' info

           Cmd str ->
              case str of 
                -- have whole words up here to avoid overlap
                "recover" -> do game' <- recover 
                                loop game' info
                "restart" -> loop newGame info
                "new"     -> loop newGame info
                "swap"    -> loop game (swapPlayers info)
                "humans"  -> loop game $ info { player = p } 
                                         where p _ = Human

                -- have one letter abbreviations here
                ('q':_)   -> putStrLn $ "Thanks for playing!"
                ('u':_)   -> loop (unmakePlies n game) info 
                                 where
                                 -- unmake until next human move
                                 opp = toggle (whoseTurn game)
                                 n = case player info opp of Human -> 1
                                                             _     -> 2
                ('l':_)   -> do game' <- loadGame defaultFileName
                                loop game' info
                ('s':_)   -> do saveGame defaultFileName game
                                loop game info
                _         -> do putStrLn $ "I don't understand " ++ str
                                loop game info


getHumanCmd :: IO Cmd
getHumanCmd 
    = do
      putStr "> "
      str <- getLine
      let parser = liftM MakeMove parseMove +++ 
                   liftM Cmd parseCmd
          parseCmd = many (item >>= return . toLower) -- .* in regex
      case papply parser str of
           [(cmd, "")] -> return cmd
           _ -> putStrLn "Couldn't parse this!" >> getHumanCmd


parseMove :: Parser Move
parseMove = do s <- parseSpecies
               d <- parseDirection
               return (Move s d)
            where
            strs ==> retVal = do msum (map symbol strs)
                                 return retVal

            parseSpecies :: Parser Species
            parseSpecies = ["w"] ==> Wolf +++ 
                           ["t"] ==> Tiger +++
                           ["m"] ==> Mouse +++
                           ["e"] ==> Elephant

            parseDirection :: Parser Direction
            parseDirection = ["8","u"] ==> U +++
                             ["2","d"] ==> D +++
                             ["4","l"] ==> L +++
                             ["6","r"] ==> R

saveGame :: FilePath -> Game -> IO ()
saveGame filename game 
    = writeFile filename (gameToString game)

loadGame :: FilePath -> IO Game
loadGame filename
    = do str <- readFile filename 
         return (stringToGame str)

{- come up with a unique way of representing a game -}
gameToString :: Game -> String
gameToString game
    = smallShow (reverse (history game))

{- inverse of gameToString -}
stringToGame :: String -> Game
stringToGame str
    = openWith ((fst . head . papply readMoveList) str)
    where
    readMoveList = many parseMove


