               {------------------------------------------------------+
               | The library of common expression parsing combinators |
               +------------------------------------------------------}

module ExprParseLib where

import MyParseLib

{---------------------+
| the new combinators |
+---------------------}

{- don't allow omission of brackets (no default parsing) -}
ternary :: String -> String -> (a -> a -> a -> a) -> Parser a -> Parser a
ternary sep1 sep2 op next
    = do
      x <- next
      do {symbol sep1; y <- next; 
          symbol sep2; z <- next; 
          return (op x y z)} +++ return x
      
{- binary operations -}
binopl, binopr :: [(String, a -> a -> a)] -> Parser a -> Parser a
binopl strOps next = chainl1 next (anyOf strOps)
binopr strOps next = chainr1 next (anyOf strOps)

-- allow for wordier things like "when ... do ..." e.g. gapr "when" "do" WhenDo subparser
gapr :: String -> String -> (a -> a -> a) -> Parser a -> Parser a
gapr before after op next
    = (do
       symbol before
       firstArg <- next
       symbol after
       secondArg <- gapr before after op next
       return (firstArg `op` secondArg)
      ) +++ next

{- singulary operations (functions) -}
prefix :: [(String, a -> a)] -> Parser a -> Parser a
prefix strFuns arg 
    = do
      funPart <- many (anyOf strFuns)  -- 0 or more lots of prefix symbol
      argPart <- arg                      -- try the next parser down 
      return (foldr ($) argPart funPart)

postfix :: [(String, a -> a)] -> Parser a -> Parser a
postfix strFuns arg
    = do
      argPart <- arg
      funPart <- many (anyOf strFuns)
      return (foldl (flip ($)) argPart funPart)

{- constants/nullary operations -}
nullary :: [(String, a)] -> Parser a
nullary = anyOf

{- utility -}
anyOf :: [(String, a)] -> Parser a
anyOf strOpPairs 
    = foldr1 (+++) [do {symbol str; return val} | (str, val) <- strOpPairs]

