module Main where

import Basics --(defaultEnvironment, eval)
import Parser
import System(getArgs)
import Types

main :: IO ()
main 
    = do
      args <- getArgs
      text <- case args of [fName] -> readFile fName
                           [] -> do putStrLn "Please enter file name: "
                                    fName <- getLine 
                                    readFile fName
                           _ -> error "Just list one filename on cmd line"
      let expr = exprParse text
      putStrLn "----"
      putStrLn "Debugging Output"
      putStrLn "Parsed expression: "
      putStrLn (niceShow expr)
      putStr "Upper bound to number of steps required: " 
      maxSteps <- numberSteps defaultEnvironment expr
      putStrLn $ (niceShow maxSteps) 
      putStrLn "----"
      ans <- eval defaultEnvironment expr
      putStrLn ("Final answer: " ++ niceShow ans ++ "")

test = putStr $ niceShow $ r
   where
    f = (!!14) $ 
        listOf defaultEnvironment (FunctionType (Product [Domain "X", Domain "X", Domain "Y"], Domain "X"))
    prop = (!!4) $ 
        listOf defaultEnvironment (FunctionType (Domain "X", Booleans))
    r = (!!14) $ 
        listOf defaultEnvironment (FunctionType (Product [Domain "Y", Domain "X"], Booleans))
