module CPU where

import CPUUtils
import Types
import Utilities

-- this module defines some CPU oppenents
randal :: Personality
randal = defPersonality { name = "Randal", moveFunction = \_ -> randMove }

beginner :: Personality
beginner = defPersonality { name = "Beginner", moveFunction = \_ -> beginner' }


decent :: Personality
decent = Personality { name = "Decent player", moveFunction = decent', 
                          tendencies = (tendencies defPersonality){mainDepth = 5 }}

{- takes a number of plies and plays like decent -}
slowcoach :: Int -> Personality
slowcoach n = Personality { name = "Slowcoach " ++ show n, 
                            moveFunction = decent', 
                            tendencies = (tendencies defPersonality)
                                                {mainDepth = n }
                          }

speedy :: Personality
speedy = Personality { name = "Speedy", moveFunction = decent',
                        tendencies = (tendencies defPersonality){mainDepth = 2, endGameDepth = 5}}

decent' :: CPUTendencies -> Game -> IO Column
decent' tend game = 
    do
    let findMates  = lookForMates game  -- Maybe Column
        maybeForce = findForceMate 
                        (forceMateDepth tend) game  -- Maybe (Column, Plies)
    case findMates of 
         Just col -> return col  -- yay! we're preventing/making a 4!
         Nothing  -> case maybeForce of
                          Just (col, _) -> return col
                          Nothing -> do col <- minimax tend game
                                        return col
                                     
                                    

{- TODO: This is bad -- it checks for forced mate before considering
   that the opponent might win on the next move! -}
cocky :: Personality
cocky = defPersonality { name = "Cocky", moveFunction = cocky' }
    where
    cocky' :: CPUTendencies -> Game -> IO Column
    cocky' tendencies game =
        do
            let p = forceMateDepth tendencies
                maybeForce      = findForceMate p game -- Maybe (Column, Plies)
                plural val stub = if (val == 0) then "" else
                                    show val ++ " " ++ stub ++ 
                                    if (val == 1) then "" else "s"
            case maybeForce of 
                Just (col,plies) -> 
                    do
                    putStrLn $ "I can win in " ++ 
                        plural (pliesToMoves plies) "move"
                    return col
                Nothing -> beginner' game


beginner' :: Game -> IO Column
beginner' game =
    do
        case (lookForMates game) of 
            Just col -> return col
            Nothing  -> randMove game
                 
            
            
-- a bland default personality
defPersonality :: Personality
defPersonality = 
    Personality { 
        name       = "Vanilla", 
        tendencies = defTendencies,
        moveFunction = \_ -> randMove
    }

defTendencies :: CPUTendencies
defTendencies = 
    let infinity = 1000000 in
    CPUTendencies { 
        mainDepth = 3, 
        trailOff = repeat 100, -- never trail off: look at all moves, all plies
        startEndGame = 11, -- how far from end to start being in end game
        endGameDepth = 11,
        forceMateDepth = 3,
        upDown = [2,10,150,infinity],
        leftRight = [3,20,180,infinity],
        diagonal = [2,15,170,infinity],
        defensiveness = 1.0
    }


