module Main where

import Types
import Utilities
import IO
import Interaction
import CPU
import Array
import CPUUtils
import System(getArgs)

-- (@) = flip ($)

demo1 = moves [4,4,3,5,2,6,1] newGame
demo2 = moves [4,4,3,5,3,6,1] newGame
demo3 = openWith [3,3,4,4]
demo4 = openWith [4,1,5,1]
demo5 = openWith [2,5,5,4,6,6,2,7,5,1,3,6]
demo6 = openWith [2,5,5,4,6,6,2,7,5,1]
demo7 = openWith [3, 3, 3, 3, 5] 
demo8 = moves [5,2,2] demo7
demo9 = openWith [4,1,3,1,1,5,4,7,4,4,3,7] -- can win in 9 plies, column 3
demo10 = openWith [4,5,5,6,5,3,4,1]

test game = positionEvaluation defTendencies game X

main :: IO ()
main = print $ demo8
     {-
    do
      let game = newGame {playerX = Computer decent}
      playGame game
     -}
    {-------------------------------------------------------------------------+
    | let nl = putStrLn ""                                                    |
    | [n] <- getArgs                                                          |
    |                                                                         |
    | putStrLn "Testing in 9 plies (should fail)"                             |
    | print demo6                                                             |
    | print (findForceMate 9 demo6)                                           |
    | nl                                                                      |
    |                                                                         |
    | putStrLn "Testing in 9 plies (should find)"                             |
    | print demo9                                                             |
    | print (findForceMate 9 demo9)                                           |
    | nl                                                                      |
    |                                                                         |
    | putStrLn "Testing in 9 plies (should find a 7-ply one)"                 |
    | print demo10                                                            |
    | print (findForceMate 9 demo10)                                          |
    | nl                                                                      |
    |                                                                         |
    | putStrLn $                                                              |
    |     "Now trying to find the best opening move (" ++ n ++ "-ply search)" |
    | x <- getMove (slowcoach (read n :: Int)) newGame                        |
    | print x                                                                 |
    +-------------------------------------------------------------------------}
