module Draw where

import AnsiInteract
import Sprite

drawSprite :: Sprite -> Interact -> Interact

drawSprite (Sprite coord gunOffset images imageIndex maxImageIndex vis _ _ _) i
   | vis = drawSpriteImage (images!!imageIndex) coord i
   | otherwise = i 

drawSpriteImage :: SpriteImage -> Coordinate -> Interact -> Interact

drawSpriteImage pixels (x,y)
   = interactList $ map (\((a,b),c) -> safeWritePixel (a,b) c) $ map (\((a,b), c) -> ((x+a, y+b), c)) pixels

blankSprite :: Sprite -> Interact -> Interact

blankSprite (Sprite coord gunOffset images imageIndex maxImageIndex vis _ _ _) i
   | vis = blankSpriteImage (images!!imageIndex) coord i
   | otherwise = i

blankSpriteImage :: SpriteImage -> Coordinate -> Interact -> Interact

blankSpriteImage pixels (x,y)
   = interactList $ map (\((a,b),_) -> safeWritePixel (a,b) ' ') $ map (\((a,b), c) -> ((x+a, y+b), c)) pixels

safeWritePixel :: Coordinate -> Char -> Interact -> Interact
safeWritePixel (x,y) c i
   | (x < 1) || (x > 80) || (y < 1) || (y > 40) = i
   | otherwise = writeAt (x,y) [c] (moveTo (1,1) i)

runI :: Interact -> IO ()
-- runI i = putStr $! i ""
runI i = seq i (putStr (i ""))

interactList :: [Interact -> Interact] -> Interact -> Interact
interactList xs i = foldr id i xs

{-
moveSprite :: Sprite -> Coordinate -> Interact -> Interact

moveSprite (Sprite (sx,sy) gunOffset images imageNumber vis) (x,y) i
   = interactList [blankSprite (Sprite (sx,sy) gunOffset images imageNumber vis),
                   drawSprite  (Sprite (x,y) gunOffset images imageNumber vis)] i
-}

pause :: Int -> Interact -> Interact
pause speed i
   | speed < 0 = error "The speed value must be non-negative"
   | otherwise = seq (fib speed) i

fib :: Int -> Int
fib 0 = 1
fib 1 = 1
fib n = (fib (n-1)) + (fib (n-2))
