module Sprite where

data Sprite
   = Sprite 
        Coordinate        -- position of the sprite (x,y)
        Coordinate        -- position of the gun relative to the above coord
        [SpriteImage]     -- a list of the images for this sprite
        Int               -- current image index 
        Int               -- max image index
        Bool              -- True=visible, False=invisible
        [Coordinate]      -- motion sequence
        Int               -- current motion index
        Int               -- max motion index
   deriving (Eq, Show)

type Coordinate = (Int, Int)


-- (offset from sprite coordiate, pixel) 
type SpriteImage = [(Coordinate,Char)]

triangleImage :: SpriteImage
triangleImage = [                            ((0,0), '#'),
                               ((-1,1), '#'), ((0,1), '#'), ((1,1), '#'),
                 ((-2,2), '#'), ((-1,2), '#'), ((0,2), '#'), ((1,2), '#'), ((2,2), '#')
                ]

gunBulletImage = [((0,0), '|')]
invBulletImage = [((0,0), '*')]

exampleGunSprite1 = Sprite (20,40) (0,-1) [triangleImage] 0 0 True [] 0 0

smallImage :: SpriteImage
smallImage =    [                            ((0,0), '#'),
                               ((-1,1), '#'), ((0,1), '#'), ((1,1), '#')
                ]

exampleGunSprite2 = Sprite (20,16) (0,-1) [smallImage] 0 0 True [] 0 0

invaderImage1 = [((-1,0), '('), ((0,0), '*'), ((1,0), ')'),
                 ((-1,1), '/'), ((1,1), '\\')]

invaderImage2 = [((-1,0), '('), ((0,0), '*'), ((1,0), ')'),
                 ((0,1), 'V')]

invaderMotion 
   = [(1,0), (1,0), (1,0), (1,0), (0,1), (-1,0), (-1,0), (-1,0), (-1,0), (0,1)]

explodeImage1 :: SpriteImage
explodeImage1 = [ ((0,0), '+')]

explodeImage2 :: SpriteImage
explodeImage2 = [ ((0,-1), '+'),
                  ((-1,0), '+'), ((0,0), '+'), ((1,0), '+'),
                  ((0,1), '+')
                ]

explodeImage3 :: SpriteImage
explodeImage3 = [ ((-1,-1), '.'), ((0,-1), '+'), ((1,-1), '.'),
                  ((-1,0), '+'),  ((1,0), '+'),
                  ((-1,1), '.'), ((0,1), '+'), ((1,1), '.')
                ]


explodeImage4 :: SpriteImage
explodeImage4 = [ ((-2,-2), '\\'), ((0,-2), '|'), ((2,-2), '/'),
                  ((-2, 0), '-'), ((2,0), '-'),
                  ((-2,2), '/'), ((0,2), '|'), ((2,2), '\\')
                ]


spriteY :: Sprite -> Int
spriteY (Sprite (_sx,sy) _gunOffset _images _imageNumber _ _vis _ _ _)
   = sy

spriteX :: Sprite -> Int
spriteX (Sprite (sx,_sy) _gunOffset _images _imageNumber _ _vis _ _ _)
   = sx

spriteXY :: Sprite -> Coordinate 
spriteXY (Sprite (sx,sy) _gunOffset _images _imageNumber _ _vis _ _ _)
   = (sx,sy)

spriteGunXY :: Sprite -> Coordinate 
spriteGunXY (Sprite (sx,sy) (gx,gy) _images _imageNumber _ _vis _ _ _)
   = (sx+gx,sy+gy)

moveSprite :: Coordinate -> Sprite -> Sprite
moveSprite (dx, dy) (Sprite (sx,sy) gunOffset images imageIndex maxImIndex vis mSeq mInd maxInd)
   = Sprite (sx + dx, sy + dy) gunOffset images imageIndex maxImIndex vis mSeq mInd maxInd

newGunBullet :: Coordinate -> Sprite
newGunBullet (x,y) 
   = Sprite (x,y) (0,0) [gunBulletImage] 0 0 True [] 0 0

newInvBullet :: Coordinate -> Sprite
newInvBullet (x,y) 
   = Sprite (x,y) (0,0) [invBulletImage] 0 0 True [] 0 0

newInvader1 :: Coordinate -> Sprite
newInvader1 (x,y)
   = Sprite (x,y) (0,0) [invaderImage1, invaderImage2] 0 1 True invaderMotion 0 9

newInvader2 :: Coordinate -> Sprite
newInvader2 (x,y)
   = Sprite (x,y) (0,0) [invaderImage2, invaderImage1] 0 1 True invaderMotion 0 9

spriteGunX :: Sprite -> Int
spriteGunX (Sprite (sx,_sy) (dx,_dy) _ _ _ _ _ _ _)
   = sx + dx

spriteGunY :: Sprite -> Int
spriteGunY (Sprite (_sx,sy) (_dx,dy) _ _ _ _ _ _ _)
   = sy + dy

-- the second part of the tuple is the lifespan of the explosion

newExplosion :: Coordinate -> Sprite 
newExplosion (x,y)
   = Sprite (x,y) (0,0) [explodeImage1, explodeImage2, explodeImage3, explodeImage4] 0 3 True [] 0 0 
