
\section{Utilities}

\subsection{Header}

This module is, strictly, not part of Pancito because it changes ``at
random'' (ie within releases).  It contains functions that I find
useful.  Often these are pulled out of previous image scripts;
sometimes existing functions are made more general.

\begin{code}

module Utilities where

import Point
import Colour
import Pancito2
\end{code}

\subsection{Motifs}

One process that interests me is tiling - repeating a motif across an
image.  I do this by defining a function that generates a motif within
square11 and then using pixelate11 (both functions in the Points
module).

Trapezium can be used to produce ``striped'' images where, for
example, stripe width depends on intensity.

\begin{code}
trapezium :: (Double, Double) -> (Colour, Colour) -> Image
trapezium (lo, hi) (fg, bg) p = if inside then fg else bg
 where
   x' = abs (x p)
   y' = y p
   x'' = lo + (hi - lo) * (y' + 1.0) / 2.0
   inside = x' < x''
\end{code}

\subsection{Other Tiling Functions}

"Round" a point to 0.5,1.5,$\ldots$

\begin{code}
centre :: Point -> Point
centre p = cartesian x' y'
  where
    x' = 0.5 + fromIntegral (floor (x p))
    y' = 0.5 + fromIntegral (floor (y p))
\end{code}

\subsection{Maths}

Limit to a certain range

\begin{code}
limit :: Ord a => a -> a -> a -> a
limit mn mx x = min (max x mn) mx
\end{code}
