-- MachineInstructions.hs
--
-- Datentyp fuer die Befehle der abstrakten Maschine

module MachineInstructions(MachineProgram, MachineInstruction(..),
                           showMachineProgram, readMachineProgram) where


type MachineProgram = [MachineInstruction]


-- Es gibt die folgenden Befehle:
-- Lesen und Beschreiben des Hauptspeichers, bedingter und unbedingter Sprung,
-- arithmetische und relationale Operationen, Anhalten.

data MachineInstruction = Lod Int | Sto Int | Jmp Int | Jmc Int |
	                  Lit Int | Ad | Sb | Ml | Dv |
	                  Eq | Ne | Gt | Ge | Lt | Le | Halt
--		          deriving (Eq, Show, Read)
                          deriving (Eq, Show)


showMI :: MachineInstruction -> String
showMI (Lod i) = "Lod " ++ show i
showMI (Sto i) = "Sto " ++ show i
showMI (Jmp i) = "Jmp " ++ show i
showMI (Jmc i) = "Jmc " ++ show i
showMI (Lit i) = "Lit " ++ show i
showMI Ad      = "Ad"
showMI Sb      = "Sb"
showMI Ml      = "Ml"
showMI Dv      = "Dv"
showMI Eq      = "Eq"
showMI Ne      = "Ne"
showMI Gt      = "Gt"
showMI Lt      = "Lt"
showMI Le      = "Le"
showMI Halt    = "Halt"


-- Schreiben und Lesen eines Maschinenprogramms.
-- Nicht als Instanz der Klassen Show und Read definiert, da eine Darstellung 
-- gewaehlt wird, die fuer den Benutzer einfach zu lesen ist, jedoch 
-- ungeignet ist, wenn ein Maschinenprogramm Teil einer komplexeren Datenstruktur
-- ist, die geschrieben bzw. gelesen werden soll.
--
-- Aufgrund der Einfachheit der Darstellung wird kein spezieller Parser zum Lesen
-- benoetigt. Allerdings ist es so auch nicht moeglich, Lesefehler abzufangen.

showMachineProgram :: MachineProgram -> String
showMachineProgram = unlines . (map showMI)

readMachineProgram :: String -> MachineProgram
readMachineProgram = undefined -- (map read) . lines

-- Ende
