-- PsaAbstractSyntax.hs
--
-- Datentypen fuer die abstrakte Syntax von PSA (abstrakter Syntaxbaum).

module PsaAbstractSyntax(Program(..), Declaration(..), StatementSequence(..), 
			 Statement(..), Expression(..), BExpression(..),
			 module PsaOperators) where

import PsaOperators

--import Observe

-- Program ::= Declaration* Statement-Sequence .

data Program = Program [Declaration] StatementSequence
               deriving Show	


-- Declaration = var Variable+ ;

data Declaration = Decl [String]
                   deriving Show
	-- Diese Liste von Variablennamen ist immer nicht-leer.


-- Statement-Sequence = Statement*

data StatementSequence = StmtSeq [Statement]
                         deriving Show

{-
instance Observable StatementSequence where

  observer (StmtSeq stmts) = send "StmtSeq" (return StmtSeq << stmts)  
-}

-- Statement ::= Variable := Expression 
--           | if BExpression then Statement-Sequence else Statement-Sequence end 
--           | while BExpression do Statement-Sequence end 

data Statement = Assignment String Expression 
	       | If BExpression StatementSequence StatementSequence 
               | While BExpression StatementSequence
               deriving Show

{-
instance Observable Statement where
  
  observer (Assignment var expr) = send "Assignment" (return Assignment << var << expr)
  observer (If test seq1 seq2) = send "If" (return If << test << seq1 << seq2)
  observer (While test seq) = send "While" (return While << test << seq)
-}

-- Expression ::= Variable 
--              |  Number 
--              |  (Expression ArithOp Expression)


data Expression = Variable Identifier 
                | Number Int 
                | Compound Expression ArithOp Expression
                deriving Show

{-
instance Observable Expression where

  observer (Variable id) = send "Variable" (return Variable << id)
  observer (Number n) = send "Number" (return Number << n)
  observer (Compound expr1 op expr2) = send "Compound" (return Compound << expr1 << op << expr2)
-}


-- BExpression ::= Expression RelOp Expression

data BExpression = BExpression Expression RelOp Expression
                   deriving Show


{-
instance Observable BExpression where
  
  observer (BExpression expr1 op expr2) = send "BExpression" (return BExpression << expr1 << op << expr2)
-}
-- Ende



