-- PsaCompiler.hs
--
-- Der Compiler fuer die Sprache PSA.
-- Ein PSA-Programm in einer Datei wird uebersetzt in ein Programm fuer
-- die abstrakte Maschine.
--
-- Die Namen eventuell mehrerer Dateien werden als Kommandozeilenargumente beim
-- Aufruf des Compilers angegeben. Ist kein Argument uebergeben worden,
-- so fragt der Compiler den Benutzer nach einem Dateinamen.
-- Dateinamen werden mit und ohne die Endung `.psa' akzeptiert; fehlt
-- die Endung `.psa', so wird sie automatisch ergaenzt. Er legt
-- das Programm fuer die A-Maschine in einer Datei gleichen Namens, aber
-- mit der Endung `.psx' ab.
--
-- Die erfolgreiche Uebersetzung jedes PSA-Programms wird gemeldet.

module Main(main, trans) where

import PsaLex(scan)
import PsaToken(Token)
import PsaParser(parsePsa)
import PsaAbstractSyntax(Program)
import PsaAnalyser(analyse, Symboltable, Table)
import PsaCodeGenerator(generateCode)
import MachineInstructions(MachineProgram, MachineInstruction, showMachineProgram)
--import Observe


main = putStr $ trans ggtProg


-- `trans' uebersetzt einen PSA-Programmtext in Befehlstext fuer die 
-- abstrakte Maschine

trans :: String -> String

trans psaProgramText 
  = showMachineProgram (generateCode syntaxtree symboltable)
  where
  symboltable = analyse syntaxtree
  syntaxtree = (parsePsa . scan) psaProgramText




-- Program for greatest common divisor

ggtProg = "\
\var x y;\n\
\x:= 42\n\
\y:= 15\n\
\while x /= y do \n\
\ if x>y then\n\
\    x:= (x-y)\n\
\ else\n\
\    y:= (y-x)\n\
\ end\n\
\end.\n"
