-- PsaLex.hs
--
-- Definition des Scanners fuer die Sprache PSA

module PsaLex(scan) where

import Basic
import PsaToken


scan :: [Char] -> [Token]	

scan [] = []
scan (h:t)
  | (isSpace h) = scan t
  | (isAlpha h) = checkId (h : alphs) : scan nonAlphs
  | (isDigit h) = Num (readInt (h : digits)) : scan nonDigits
  | (t /= [] && isTwoCharOp [h ,head t]) 
		= twoOpSym [h, head t] : scan (tail t)
  | otherwise   = oneOpSym h : scan t
  where
  (alphs, nonAlphs) = span isAlphaNum t
  (digits, nonDigits) = span isDigit t
  isTwoCharOp c  = c `elem` ["/=","<=",">=",":="]


checkId :: String -> Token

checkId "if"	 = IfSym
checkId "then"	 = ThenSym
checkId "else"	 = ElseSym
checkId "end"	 = EndSym
checkId "while"  = WhileSym
checkId "do"	 = DoSym
checkId "var"	 = VarSym
checkId str	 = Ident str


twoOpSym :: String -> Token

twoOpSym "/=" = RelOp NotEqual
twoOpSym "<=" = RelOp LessOrEqual
twoOpSym ">=" = RelOp GreaterOrEqual
twoOpSym ":=" = AssignOp


oneOpSym :: Char -> Token

oneOpSym ';' = Semicolon
oneOpSym '+' = ArithOp Plus
oneOpSym '-' = ArithOp Minus
oneOpSym '*' = ArithOp Times
oneOpSym '/' = ArithOp Div
oneOpSym '=' = RelOp Equal
oneOpSym '<' = RelOp LessThen
oneOpSym '>' = RelOp GreaterThen
oneOpSym '(' = OpenPar
oneOpSym ')' = ClosePar       
oneOpSym '.' = FullStop
oneOpSym c   = error ("Illegal character: " ++ [c])

-- Ende
