-- PsaToken.hs
--
-- Definition der vom Scanner produzierten und vom Parser konsumierten
-- Token

module PsaToken(module PsaOperators, Token(..)) where

import PsaOperators

data Token =
  ArithOp ArithOp | AssignOp | ClosePar | DoSym | ElseSym | EndSym | 
  FullStop | Ident Identifier | IfSym | Num Int | OpenPar | RelOp RelOp | 
  Semicolon | ThenSym | VarSym | WhileSym 
  deriving Eq

{-
instance Eq Token where
   ArithOp a == ArithOp b = a == b
   AssignOp == AssignOp = True
   ClosePar == ClosePar = True
   DoSym == DoSym = True
   ElseSym == ElseSym = True
   EndSym == EndSym = True
   FullStop == FullStop = True
   Ident i == Ident j = i == j
   IfSym == IfSym = True
   Num n == Num m = n == m
   OpenPar == OpenPar = True
   RelOp r == RelOp s = r == s
   Semicolon == Semicolon = True
   ThenSym == ThenSym = True
   VarSym == VarSym = True
   WhileSym == WhileSym = True
   _ == _ = False
-}

-- Ende

