-- Table.hs
-- 
-- Abstrakter Datentyp assoziative Tabelle
-- Table stellt die folgenden Operationen zur Verfuegung:
--      - Erzeugung einer leeren Tabelle
--      - Einfuegung eines Eintrages (ein eventuell vorhandener alter Eintrag
--        wird ueberschrieben)
--      - Lesender Zugriff auf einen Tabelleneintrag
--          Ergebnis eines lesenden Zugriffs kann entweder ein Eintrag sein oder 
--          die Auskunft, dass unter diesem Index kein Wert eingetragen ist.

module Table(Table, tableEmpty, tableInsert, tableRead) where

--import Observe

tableEmpty  :: Eq index => Table index entry
tableInsert :: Eq index => index -> entry -> Table index entry -> Table index entry
tableRead   :: Eq index => index -> Table index entry -> Maybe entry


-- Wir waehlen eine Implementierung durch eine Funktion, da dies die
-- einfachste Art von assoziativer Tabelle darstellt.

data Table index entry = TableImp (index -> Maybe entry)

{-
instance (Observable index, Observable entry) 
         => Observable (Table index entry) where

  observer (TableImp imp) = send "TableImp" (return TableImp << imp)
-}

tableEmpty = TableImp implTableEmpty
  where
  implTableEmpty index = Nothing 


tableInsert newIndex newEntry (TableImp oldTableFunction)
  = TableImp newTableFunction
  where
  newTableFunction index
    | (index == newIndex) = Just newEntry
    | otherwise		  = oldTableFunction index


tableRead index (TableImp tableFunction)
  = tableFunction index

-- Ende

