{-------------------------------------------------------------------------------

        module:         Data.hs

        author:         Bernie Pope

        date:           September 1998

        notes:          Implements the data types for the raytracer.

-------------------------------------------------------------------------------}

module Data  where


data Coordinate3D = Coord3D {cx, cy, cz::Double} 
                    deriving (Eq, Show)

type LineSegment = (Coordinate3D, Coordinate3D)


data Vector3D = Vect3D {vx, vy, vz::Double} 
                deriving (Eq, Show)

data Plane3D = Plane3D {pa, pb, pc, pd::Double}
               deriving (Eq, Show)

type Intensity = Double

data Light = 
   Light {lcoord::Coordinate3D, intensity::Intensity}
   deriving (Eq, Show)

-- A polygon must have at least three points. All points in the polygon
-- must be co-planar. We will use the convention that the first point is
-- the same as the last point

data Object = 
   Sphere {scoord::Coordinate3D, 
           radius::Double,
	   sphereKa::Double,			-- ambient coeff
	   sphereKd::Double,			-- diffuse coeff
	   sphereKs::Double,			-- specular coeff
	   shpereSpecExp::Double}		-- phong specular exponent
   | Polygon {polygonPoints::[Coordinate3D],    -- vertices
           polygonKa::Double,                   -- ambient coeff
           polygonKd::Double,                   -- diffuse coeff
           polygonKs::Double,                   -- specular coeff
           polygonSpecExp::Double,              -- phong specular exponent
	   polygonPlane::Plane3D}               -- plane of the polygon
   deriving (Eq, Show)

type Scene = ([Object], [Light]) 

type Image = [Int]
