{-------------------------------------------------------------------------------

        module:         Geometry.hs

        author:         Bernie Pope

        date:           April 2000 

        notes:          Implements some simple geometrical ops for the 
			raytracer.

-------------------------------------------------------------------------------}

module Geometry where

import Data

translate :: Double -> Double -> Double -> Coordinate3D -> Coordinate3D

translate tx ty tz pt
   = Coord3D newx newy newz
   where
   px = cx pt
   py = cy pt
   pz = cz pt
   newx = px + tx
   newy = py + ty
   newz = pz + tz


scale :: Double -> Double -> Double -> Coordinate3D -> Coordinate3D
   
scale sx sy sz pt
   = Coord3D newx newy newz
   where
   px = cx pt
   py = cy pt
   pz = cz pt
   newx = px * sx
   newy = py * sy
   newz = pz * sz

-- rotations are in degrees

rotateZ :: Double -> Coordinate3D -> Coordinate3D

rotateZ rz pt
   = Coord3D newx newy newz
   where
   px = cx pt
   py = cy pt
   pz = cz pt
   newx = (px * c) - (py * s)
   newy = (px * s) + (py * c)
   newz = pz
   c = cos radianRotate 
   s = sin radianRotate
   radianRotate = (rz*2*pi)/360

rotateY :: Double -> Coordinate3D -> Coordinate3D

rotateY ry pt
   = Coord3D newx newy newz
   where
   px = cx pt
   py = cy pt
   pz = cz pt
   newx = (px * c) + (pz * s) 
   newy = py 
   newz = (pz * c) - (px * s) 
   c = cos radianRotate
   s = sin radianRotate 
   radianRotate = (ry*2*pi)/360

rotateX :: Double -> Coordinate3D -> Coordinate3D

rotateX rx pt
   = Coord3D newx newy newz
   where
   px = cx pt
   py = cy pt
   pz = cz pt
   newx = px
   newy = (py * c) - (pz * s) 
   newz = (py * s) + (pz * c) 
   c = cos radianRotate
   s = sin radianRotate 
   radianRotate = (rx*2*pi)/360

