{-------------------------------------------------------------------------------

        module:         Main.hs

        author:         Bernie Pope

        date:           September 1998

        notes:          Implements the main functions for the ray tracer.

-------------------------------------------------------------------------------}

module Main where

import System
import Data
import Parser
import Pgm
import RayTrace
import IO


  -- subMain f W H [files...]

{-
myScene = ([ Sphere (Coord3D 0.0 0.0 (-3.0)) 1.0 0.3 0.6 0.1 20],
            [ Light (Coord3D 0 0 0) 1 ])
-}
myScene = ( [ Sphere { scoord = Coord3D { cx = 0.0
                                        , cy = 0.0
                                        , cz = (-3.0)
                                        -- , cz = 3.0
                                        }
                     , radius = 1.0 
                     , sphereKa = 0.3
                     , sphereKd = 0.6
                     , sphereKs = 0.1
                     , shpereSpecExp = 20 }
            ],
            [ Light { lcoord = Coord3D { cx = 0
                                       , cy = 0
                                       , cz = 0
                                       } 
                    , intensity = 1
                    } 
            ])
                    

subMain :: Double -> Int -> Int -> [FilePath] -> IO ()

subMain focal_length width height inFiles 
   = do
      hPutStrLn stderr "Parsing Input"
      scene <- myParse inFiles
      hPutStrLn stderr "Done parsing"
      printScene scene
      hPutStrLn stderr ("Rendering Scene" ++ imageStats ++ "\n")
      writePgm (rayTrace scene width height focal_length) stdout width height
      hPutStrLn stderr "Complete"
      where
         imageStats = " " ++ (show width) ++ "x" ++ (show height)


main :: IO ()

main 
   = do
      (focal_length, width, height, inFiles) <- getOpts 
      subMain focal_length width height inFiles

getOpts :: IO (Double, Int, Int, [FilePath])

getOpts
   = do 
      argv <- getArgs
      processArgs argv

processArgs :: [String] -> IO (Double, Int, Int, [FilePath])

processArgs argv
   | length argv < 4 = return defaultArgs
   | otherwise = return (f, w, h, files)
   where
   defaultArgs = (10, 99, 99, [])
   f = read (argv !! 0)
   w = read (argv !! 1)
   h = read (argv !! 2)
   files = drop 3 argv

printScene :: Scene -> IO ()

printScene s 
   = do hPutStrLn stderr (show $ fst s)
        hPutStrLn stderr (show $ snd s)
