{-------------------------------------------------------------------------------

        module:         Vector.hs

        author:         Bernie Pope

        date:           September 1998

        notes:          Implements various vector manipulation functions for
			the raytracer. 

-------------------------------------------------------------------------------}

module Vector where

import Data

normalise :: Vector3D -> Vector3D

{-
normalise v1@(Vect3D x y z)
   = (Vect3D x' y' z')
   where
   magnitude = sqrt ((x*x) + (y*y) + (z*z))
   x' = x / magnitude
   y' = y / magnitude
   z' = z / magnitude
-}

normalise v
   = Vect3D {vx = x',  vy = y', vz = z'}
   where
   x = vx v
   y = vy v
   z = vz v
   magnitude = sqrt ((x*x) + (y*y) + (z*z))
   x' = x / magnitude
   y' = y / magnitude
   z' = z / magnitude

dotProduct :: Vector3D -> Vector3D -> Double 

{-
dotProduct v1@(Vect3D x1 y1 z1) v2@(Vect3D x2 y2 z2)
   = (x1 * x2) + (y1 * y2) + (z1 * z2)
-}
dotProduct v1 v2
   = vx v1 * vx v2 + vy v1 * vy v2 + vz v1 * vz v2
