module Auxil(Maybe(..), assoc, assocm, subset, union,
             first, histo, sorted, partition) where

-- data Maybe a = Nothing | Just a
--               deriving Show

assoc :: (Eq a) => a -> [(a,b)] -> b
assoc x ((y,z):yzs) = if x == y then z else assoc x yzs

assocm :: (Eq a) => a -> [(a,b)] -> Maybe b
assocm x [] = Nothing
assocm x ((y,z):yzs) = if x == y then Just z else assocm x yzs

subset :: (Eq a) => [a] -> [a] -> Bool
subset xs ys = all (`elem` ys) xs

union :: (Eq a) => [a] -> [a] -> [a]
union xs ys = xs ++ [y | y <- ys, y `notElem` xs]

first :: (a -> Maybe b) -> [a] -> Maybe b  
first _ [] = Nothing
first f (x:xs) = case f x of
                 jy@(Just y) -> jy
                 Nothing     -> first f xs

histo :: (Eq a) => [a] -> [(a,Int)]
histo = foldr histins []
        where
        histins x [] = [(x,1)]
        histins x (yn@(y,n):yns) = if x==y then (y,n+1):yns
                                   else yn:histins x yns

sorted :: (a->a->Bool) -> [a] -> [a]
sorted lt =
    foldr ins []
    where
    ins x [] = [x]
    ins x (y:ys) = if lt x y then x:y:ys else y:ins x ys

partition :: (a->Bool) -> [a] -> ([a],[a])
partition p =
    foldr f ([],[])
    where
    f x (ys,ns) = if p x then (x:ys,ns) else (ys,x:ns)
