module Hash(HashFun, findhash) where

import Auxil
import Key

data HashSet = H (Maybe Int) (Maybe Int) [Int]

type HashFun = [(Char,Int)]

findhash :: Int -> [Key] -> Maybe HashFun
findhash mv ks = findhash' mv (length ks) (H Nothing Nothing []) [] ks

findhash' :: Int -> Int -> HashSet -> HashFun -> [Key] -> Maybe HashFun
findhash' maxval nk khs cvs [] = Just cvs
findhash' maxval nk khs cvs (k@(K s a z n):ks) =
  ( case (assocm a cvs) of
  Nothing -> case (assocm z cvs) of
             Nothing ->
               if a==z then first (\m->try [(a,m)]) range
               else first (\(m,n)->try [(a,m),(z,n)]) 
                          (concat (map (\m -> map (\n->(m,n)) range) range))
                          -- [(m,n) | m<-range, n<-range]
             Just zc -> first (\m->try [(a,m)]) range
  Just ac -> case (assocm z cvs) of
             Nothing -> first (\n->try [(z,n)]) range
             Just zc -> try [] )
  where
  range = [0..maxval]
  try dhf = ( case hinsert nk (hash cvs' k) khs of
            Nothing -> Nothing
            Just khs' -> findhash' maxval nk khs' cvs' ks )
            where
            cvs' = dhf ++ cvs

hinsert :: Int -> Int -> HashSet -> Maybe HashSet
hinsert nk h (H lo hi hs) =
    if h `elem` hs || 1 + hi'- lo' > nk then Nothing
    else Just (H (Just lo') (Just hi') (h:hs))
    where
    lo' = case lo of Nothing -> h ; (Just x) -> min x h
    hi' = case hi of Nothing -> h ; (Just x) -> max x h

hash :: HashFun -> Key -> Int
hash hf (K _ a z n) = n + assoc a hf + assoc z hf 
