module Key(Key(..), freqsorted, blocked, enKey) where 

import Auxil 

data Key = K String Char Char Int

ends :: Key -> String
ends (K _ a z _) = [a,z]

freqsorted :: [Key] -> ([Key], Int)
freqsorted ks =
  ( sorted ( \ (K _ a x _) (K _ b y _) ->
           freq a + freq x > freq b + freq y ) ks,
    length freqtab )
  where
  freq c = assoc c freqtab
  freqtab = freqTabOf ks 

freqTabOf :: [Key] -> [(Char, Int)]
freqTabOf = histo . concat . map ends

blocked :: [Key] -> [Key]
blocked = blocked' []
blocked' ds [] = []
blocked' ds (k : ks) = k : det ++ blocked' ds' rest
                     where
                     (det,rest) = partition (\x->subset (ends x) ds') ks
                     ds' = union ds (ends k)

enKey :: String -> Key
enKey k = K k (head k) (last k) (length k)
  where
  head "v" = 'v'
  head ('v':xs) = head xs
  head (x:xs) = x
