module Main where

import AST
import FCDinHaskell

-- some examples for the interpreter

-- take :: Int -> [] -> []
-- take _ [] = []
-- take Z _ = []
-- take (S n) (x:xs) = x : take n xs

nilCon :: (Name,[LS])
nilCon = ("Nil", [])
consCon :: (Name,[LS])
consCon = ("Cons", [Lazy,Lazy]) 

zeroCon :: (Name,[LS])
zeroCon = ("Z", [])
succCon :: (Name,[LS])
succCon = ("S", [Lazy])

takeDecl :: D
takeDecl
   = Fun "take" takeClauses
   where
   takeClauses :: [Clause]
   takeClauses = [c1, c2, c3]
   c1, c2, c3 :: Clause
   c1 = mkClause [Pwildcard, Pcondata "Nil" []] (ConApp nilCon [])
   c2 = mkClause [Pcondata "Z" [], Pwildcard]   (ConApp nilCon [])
   c3 = mkClause [Pcondata "S" [Pvar "n"], Pcondata "Cons" [Pvar "x", Pvar "xs"]]
                 (ConApp consCon [Var "x", takeApp])
      where
      takeApp :: E
      takeApp = App (App (Var "take") (Var "n")) (Var "xs")

mkClause :: [P] -> E -> Clause
mkClause pats e = (pats, Normal e, [])

-- infinite list of nats

-- nats n = Cons n (nats (S n))
natsDecl :: D
natsDecl
   = Val (Pvar "nats") natsBody []
   where
   natsBody :: B
   natsBody = Normal $ Abs [Pvar "n"] $ ConApp consCon [Var "n", rest]
   rest     = App (Var "nats") $ ConApp succCon [Var "n"]
   -- rest     = "nats" @@ ConApp succCon [Var "n"]

-- expression to evaluate
-- let natsDecl takeDecl in take (S (S (S Z))) (nats Z)
-- (take 3 nats)

expr1 :: E
expr1 = Let [natsDecl, takeDecl] (take_3 @@ nats_Z)
      where
      take_3 :: E
      take_3 = App (Var "take") (mkNum 3)
      nats_Z :: E
      nats_Z = App (Var "nats") (mkNum 0)
      -- take_3 = v "take" @@ (3::Int)
      -- nats_Z = v "nats" @@ (0::Int)

-- make a syntactic form of a natural from an int
mkNum :: Int -> E
mkNum n
   | n <= 0 = ConApp zeroCon []
   | otherwise = ConApp succCon [mkNum (n-1)]

main = print $ go expr1

infixl 9 @@ 

(@@) :: (ToE a, ToE b) => a -> b -> E
e1 @@ e2 = App (e e1) (e e2)

class ToE a where
   e :: a -> E
   v :: [a] -> E
   
instance ToE Int where
   -- e n = Const (fromIntegral n)
   e n = mkNum n 

instance ToE Integer where
   -- e n = Const n
   e n = mkNum (fromInteger n)
  
instance ToE Char where
   e c = Undefined -- system does not have a character literal
   v cs  = Var cs

instance ToE E where
   e exp = exp

instance ToE a => ToE [a] where
   e [] = Undefined
   e list@(x:xs) = foldl1 App $ map e list
