-- The classic queens problem made famous by Wirth.

main =
  if null solutions then putStrLn "no solution!"
  else putStr (board (head solutions))
  where
  solutions = queens 4

queens :: Int -> [[Int]]
queens n = valid n n 

valid :: Int -> Int -> [[Int]]
valid 0 n = [[]]
valid m n = filter safe (extend n (valid (m-1) n)) 

extend n b = cp [1..n] b 

cp :: [a] -> [[a]] -> [[a]]
cp [] y = []
cp (a:x) y = consall a y ++ cp x y 

consall a [] = []
consall a (y:ys) = (a:y) : consall a ys

safe (a:b) = no_threat a b 1

no_threat a [] m = True
no_threat a (b:y) m =
  a /= b && a+m /= b && a-m /= b && no_threat a y (m+1) 

board :: [Int] -> String 
board b =
  unlines (concat (zipWith rank [1..] b))
  where
  rank r qcol =
    map line ["o o o", " \\|/ ", " === "]
    where
    line crown_slice =
      concat (zipWith square [1..] b)
      where
      square scol _ =
	if scol == qcol then crown_slice
	else if scol `rem` (2::Int) == r `rem` (2::Int) then "....."
	else "     "
