module Network (Assoc(..), site_plan, successors, location) where

-- A representation of the campus.  For each location
-- on campus there is an XY grid reference and a list of
-- successors with costs.  The unit measure for the grid is one
-- second of unhurried walking; similarly for successor costs.

data Assoc a b = a := b

site_plan :: [Assoc String ((Int, Int), [Assoc String Int])]
site_plan = [
    "Wentworth" :=
      ( ( 72, 36) , [ "Biology":=162 ] ),
    "Biology" :=
      ( ( 54,162) , [ "Wentworth":=62, "T-junction":=108 ] ),
    "T-junction" :=
      ( (144,198) , [ "Goodricke":=90, "Biology":=108, "Vanbrugh":=54 ] ),
    "Goodricke" :=
      ( (162,126) , [ "T-junction":=90, "Physics":=90 ] ),
    "Physics" :=
      ( (234,126) , [ "Goodricke":=90, "Central Hall":=108 ] ),
    "Central Hall" :=
      ( (234,216) , [ "Physics":=108, "Vanbrugh":=72, "Langwith":=162 ] ),
    "Vanbrugh" :=
      ( (180,234) , [ "T-junction":=54, "Library":=144, "Central Hall":=72 ] ),
    "Library" :=
      ( (198,342) , [ "Vanbrugh":=144, "Alcuin":=90 ] ),
    "Alcuin" :=
      ( (288,342) , [ "Library":=90, "Chemistry":=90 ] ),
    "Chemistry" :=
      ( (378,342) , [ "Langwith":=72, "Alcuin":=90 ] ),
    "Langwith" :=
      ( (360,288) , [ "Central Hall":=162, "Chemistry":=72, "Derwent":=72 ] ),
    "Derwent" :=
      ( (414,252) , [ "Langwith":=72, "Heslington Hall":=90] ),
    "Heslington Hall" :=
      ( (486,234) , [ "Derwent":=90 ] ) ]

assoc :: (Eq a) => a -> [Assoc a b] -> b
assoc j ((i:=v) : ivs) = if i==j then v else assoc j ivs

successors :: String -> [Assoc String Int]
successors s = snd (assoc s site_plan)

location :: String -> (Int, Int)
location s = fst (assoc s site_plan)
