module Main where

import IO(hGetLine, stdin)
import Network (site_plan, location)
import Search (search)

main = do
    putStr "from? "
    f <- hGetLine stdin
    putStr "to? "
    t <- hGetLine stdin
    putStrLn (route f t)

goal :: String -> String -> Bool
goal g s = s == g

distance :: (Int,Int) -> (Int,Int) -> Int
distance (x0, y0) (x1, y1) =
    if dx > dy then dx else dy
    where
    dx = abs(x0-x1)
    dy = abs(y0-y1)

estimate :: String -> String -> Int 
estimate g s = distance (location g) (location s)

express :: [String] -> String
express [s] = s
express (s:p) = s ++ " to " ++ express p

-- The arguments to `route' are initial and goal locations, and
-- its result is a description of a shortest route between the two.

route :: String -> String -> String
route i g =
    case search (goal g) (estimate g) i of
    Nothing -> 
	"No known route.  Sorry."
    Just (p,t) ->
	express p ++ " (" ++
	show (t `div` 60) ++ "m " ++
	show (t `rem` 60) ++ "s)"

