-- A* search (knowledge-aided branch and bound)

module Search(search, Route) where

import Network (Assoc(..),successors)
import Maybe

type Route = ([String], Int) 
cost = snd

estimate :: (String->Int) -> Route -> Int
estimate h ((s:p), c) = c + h s

inswrt :: (Ord a) => (b->a) -> b -> [b] -> [b]
inswrt f x =
    ins
    where
    ins [] = [x]
    ins (ys @ (z:zs)) =
        if f z >= f x then x : ys else z : ins zs

extended :: (String->Int) -> [Route] -> [String] -> [Route]
extended h ((p,cp):rt) ss =
    ext (successors (head p)) rt
    where
    ext [] rr = rr
    ext (sc@(s:=c):st) rr =
	if s `elem` ss then ext st rr
        else ext st (join h s (s:p,c+cp) rr)

join :: (String->Int) -> String -> Route -> [Route] -> [Route]
join h s r rr =
    if null rs1 then
        inswrt (estimate h) r rs0
    else if cost r < cost (head rs1) then 
        inswrt (estimate h) r rs0 ++ tail rs1
    else
        rr
    where
    (rs0, rs1) = break (\((s':_),_)->(s==s')) rr

-- h is a heuristic function: given a state argument it returns an
-- estimate of the solution cost from that state.  If this estimate
-- is always a lower bound, A* finds an optimal solution.

search :: (String->Bool) -> (String->Int) -> String -> Maybe Route
search g h i =
    search' [([i],0)] []
    where
    search' [] ss =
	Nothing
    search' (rs @ ((p,c):_)) ss =
	if g (head p) then Just (reverse p, c)
	else search' (extended h rs ss) (head p : ss)
