--------------------------------------------------
-- Finds solutions to cryptarithmetic sum puzzles.
-- Input lines such as `CROSS + ROADS = DANGER'.
-- Colin Runciman, University of York, January '96
-- Better use of prelude and libraries, but avoiding
-- comprehensions, June 2001
--------------------------------------------------

import List((\\))
import Char(isAlpha, chr, ord)
import Maybe(fromJust)

type Soln = [(Char, Int)]

main = interact solveAll

solveAll input = unlines (map solve (lines input))

solve :: String -> String
solve p =
  display p (solutions xs ys zs 0 [])
  where
  [xs,ys,zs] = map reverse (words (filter (`notElem` "+=") p))

display :: String -> [Soln] -> String
display p []    = "No solution!"
display p (s:_) =
  map soln p
  where
  soln c = if isAlpha c then chr (ord '0' + img s c) else c

rng :: Soln -> [Int]
rng = map snd

img :: Soln -> Char -> Int
img lds l = fromJust (lookup l lds)

bindings :: Char -> [Int] -> Soln -> [Soln]
bindings l ds lds =
  case lookup l lds of
  Nothing  -> map (\d -> (l,d):lds) (ds \\ rng lds)
  Just d -> if d `elem` ds then [lds] else []

solutions :: String -> String -> String -> Int -> Soln -> [Soln]
solutions [] [] []  c lds = if c==0 then [lds] else []
solutions [] [] [z] c lds = if c==1 then bindings z [1] lds else []
solutions (x:xs) (y:ys) (z:zs) c lds =
  solns `ofAll`
  bindings y [(if null ys then 1 else 0)..9] `ofAll`
  bindings x [(if null xs then 1 else 0)..9] lds
  where  
  solns s = 
    solutions xs ys zs (xy `div` 10) `ofAll` bindings z [xy `mod` 10] s
    where    
    xy = img s x + img s y + c

infixr 5 `ofAll`
ofAll :: (a -> [b]) -> [a] -> [b]
ofAll = concatMap
