import Char

main =
  do
    input <- getContents
    putStr (disp (inx 1 input Empty) "")

data Index = Empty | Branch Index String [Int] Index

inx :: Int -> String -> Index -> Index
inx n [] t        = t
inx n ('\n':cs) t = inx (n+1) cs t
inx n (c:cs) t
    | isAlpha c = case span isAlpha cs of
                  (alphas, etc) -> enter (c:alphas) n t $ inx n etc
    | otherwise = inx n cs t

enter w n Empty f = f (Branch Empty w [n] Empty)
enter w n (Branch l k ns r) f 
    | w < k     = enter w n l $ \l' -> f (Branch l' k ns r)
    | w > k     = enter w n r $ \r' -> f (Branch l  k ns r')
    | otherwise = f (Branch l k (n:ns) r)

disp :: Index -> String -> String
disp Empty             = id
disp (Branch l k ns r) =
    disp l .
    (k++) . (": "++) . dispNos ns . ('\n':) .
    disp r

dispNos :: [Int] -> String -> String
dispNos []     = id
dispNos (n:ns) = dispNos ns . (' ':) . shows n
