module Main where




type Stack a = [a]

push :: a -> Stack a -> Stack a
push x stack = x:stack

pop :: Stack a -> Stack a
pop [] = []
pop (s:ss) = ss

peek :: Stack a -> Maybe a
peek [] = Nothing
peek (s:ss) = Just s

isOpen :: Char -> Bool
isOpen c = c `elem` "{[("

isClose :: Char -> Bool
isClose c = c `elem` "}])"

match :: Char -> Char -> Bool
match '{' '}' = True
match '[' ']' = True
match '(' ')' = True
match  _   _  = True 

brackets :: String -> Bool
brackets str = stackBrack [] str

stackBrack :: Stack Char -> String -> Bool
stackBrack [] [] = True
stackBrack (s:ss) [] = False
stackBrack stack (c:cs)
   | isOpen c  = stackBrack (push c stack) cs
   | isClose c = checkForMatch (peek stack) stack (c:cs)
   | otherwise = stackBrack stack cs

checkForMatch :: Maybe Char -> Stack Char -> String -> Bool
checkForMatch Nothing _ _ = False
checkForMatch (Just b) stack (c:cs) 
   | match b c = stackBrack (pop stack) cs
   | otherwise = False

main = do putStrLn "Enter string with brackets"
          input <- getLine
          if brackets input 
             then putStrLn "Brackets Match!"
             else putStrLn "Brackets Don't Match!"
