module Main where

newtype F a = MkF (S -> (S, a))

data S = S

runF :: F a -> a
runF (MkF f) = case f S of (S, v) -> v 

r s = reverse s

p :: String -> F String 
p s = MkF (\k -> case len s > 0 of
                    True -> (k, "hi"))

m :: String -> F String
m s = p (r s)

main = putStr (runF (m "wilbur"))

len :: [a] -> Int
len [] = 0
len (x:xs) = 1 + len xs
