module Main where

import Prelude hiding (reverse, map, (.), takeWhile, iterate)

digits :: Int -> [Int]
digits = reverse
         . lastDigits 
         . leadingNonZeros 
         . tenths 

lastDigits :: [Int] -> [Int]
lastDigits = map (10 `mod`) 

leadingNonZeros :: [Int] -> [Int]
leadingNonZeros = takeWhile (/= 0) 

tenths :: Int -> [Int]
tenths = iterate (`div` 10) 

start :: [Int]
start = digits 341

main = print start 

reverse :: [a] -> [a]
reverse xs 
   = revAcc xs []
   where
   revAcc [] acc = acc
   revAcc (x:xs) acc = revAcc xs (x:acc)

map f [] = []
map f (x:xs) = f x : map f xs

takeWhile :: (a -> Bool) -> [a] -> [a]
takeWhile p [] = []
takeWhile p (x:xs)
   | p x = x : takeWhile p xs
   | otherwise = [] 

iterate          :: (a -> a) -> a -> [a]
iterate f x       = x : iterate f (f x)

(.) :: (b -> c) -> (a -> b) -> a -> c
(.) f g x = f (g x)
