module Main where

import Prelude hiding (reverse, map, (.), takeWhile, iterate)

digits :: Int -> [Int]
digits = reverse 
         . map (`mod` 10) 
         . takeWhile (/= 0)
         . iterate (`div` 10)

start = digits 340

main = print start 

reverse xs 
   = revAcc xs []
   where
   revAcc [] acc = acc
   revAcc (x:xs) acc = revAcc xs (x:acc)

map f [] = []
map f (x:xs) = f x : map f xs

takeWhile :: (a -> Bool) -> [a] -> [a]
takeWhile p [] = []
takeWhile p (x:xs)
   | p x = x : takeWhile p xs
   | otherwise = [] 

iterate          :: (a -> a) -> a -> [a]
iterate f x       = x : iterate f (f x)

-- (f . g) x = f (g x)
(.) f g x = f (g x)
