-- Bird's famous algorithm for computing the minimum 
-- value in a tree and making every node equal that value
-- in one pass using laziness

data Tree a = L a | B (Tree a) (Tree a)
            deriving Show

copy :: Tree Int -> Int -> (Tree Int, Int)
copy (L a) m = (L m, a)
copy (B l r) m = let (l', ml) = copy l m
                     (r', mr) = copy r m
                 in (B l' r', ml `min` mr)

repmin :: Tree Int -> Tree Int
repmin t = let x = copy t (snd x) in (fst x) 

main = print (repmin (B (L 11) (B (L 2) (L 3))))

