module Main where

data Exp = App Exp Exp 
         | Lam String Exp
         | Var String
         deriving Show

type Parser a = (String -> [(a, String)])

infixr 4 <|>
infixr 4 <&>

(<|>) :: Parser a -> Parser a -> Parser a
p1 <|> p2 = (\toks -> p1 toks ++ p2 toks)

(<&>) :: Parser a -> (a -> Parser b) -> Parser b
p1 <&> f = (\toks -> concat [f val rest | (val,rest) <- p1 toks])

ret :: a -> Parser a
ret x = (\toks -> [(x, toks)])

pExp :: Parser Exp
pExp = pApp <|> pLam <|> pVar

pApp :: Parser Exp
pApp = pLit "@" <&> \_ ->
       pExp     <&> \e1 ->
       pExp     <&> \e2 ->
       ret (App e1 e2)

pLam :: Parser Exp
pLam = pLit "\\" <&> \_ ->
       pIdent    <&> \v ->
       pLit "->" <&> \_ ->
       pExp      <&> \e ->
       ret (Lam v e)

pVar :: Parser Exp
pVar = pIdent <&> \a ->
       ret (Var a)

sat :: (Char -> Bool) -> Parser Char
sat pred = item <&> \x -> if pred x then ret x else zero 

item :: Parser Char
item = (\inp -> case inp of
                     [] -> []
                     (x:xs) -> [(x,xs)])
zero :: Parser a 
zero = (\_ -> [])

char :: Char -> Parser Char
char c = sat (c ==)

pLit :: String -> Parser String
pLit [] = ret []
pLit (x:xs) 
   = char x <&> \_ ->
     pLit xs <&> \_ ->
     ret (x:xs) 

pIdent :: Parser String
pIdent = pLit "v"  

main = print $ pExp "\\v -> v"
