module Main where

data Exp = App Exp Exp 
         | Lam String Exp
         | Var String
         deriving Show

newtype Parser a = P (String -> [(a, String)])

instance Monad Parser where
   return x = P (\s -> [(x, s)])
   (>>=) (P p) f = P (\inp -> concat [papply (f v) out | (v,out) <- p inp]) 

papply :: Parser a -> String -> [(a, String)]
papply (P p) inp = p inp

infixr 4 <|>

(<|>) :: Parser a -> Parser a -> Parser a
(<|>) (P p1) (P p2) = P (\inp -> (p1 inp ++ p2 inp))

pExp :: Parser Exp
pExp = pApp <|> pLam <|> pVar 
-- pExp toks = pApp toks ++ pLam toks ++ pVar toks

{-
pApp :: Parser Exp
pApp toks = (pLit "@" <&> \_ ->
             pExp     <&> \e1 ->
             pExp     <&> \e2 ->
             ret (App e1 e2)) toks
-}
pApp :: Parser Exp
pApp = do pLit "@" 
          e1 <- pExp
          e2 <- pExp 
          return (App e1 e2) 

{-
pLam :: Parser Exp
pLam toks = (pLit "\\" <&> \_ ->
             pIdent    <&> \v ->
             pLit "->" <&> \_ ->
             pExp      <&> \e ->
             ret (Lam v e)) toks
-}
pLam :: Parser Exp
pLam = do pLit "\\"
          v <- pIdent
          pLit "->"
          e <- pExp
          return (Lam v e) 

{-
pVar :: Parser Exp
pVar toks 
   = (pIdent <&> \a ->
     ret (Var a)) toks
-}
pVar :: Parser Exp
pVar 
   = do a <- pIdent
        return (Var a)

item :: Parser Char
item = P (\inp -> case inp of
                     []     -> []
                     (x:xs) -> [(x,xs)])


sat :: (Char -> Bool) -> Parser Char 
sat p              
   = do x <- item 
        if p x then return x else zero

zero :: Parser a 
zero = P (\inp -> [])

char :: Char -> Parser Char
char c = sat (c ==) 

pLit :: String -> Parser String
pLit [] = return [] 
pLit (x:xs) 
   = do char x 
        pLit xs 
        return (x:xs) 

pIdent :: Parser String
pIdent = pLit "v" 

main = print $ papply pExp "\\v -> v"
