module Main where

main = print $ len $ mkList "abc"

newtype List a = L (Int -> Maybe a)

at :: List a -> Int -> Maybe a
at (L list) n = list n 

hd :: List a -> a
hd (L list)
   = case list 0 of
        Nothing -> error "empty list"
        Just a  -> a 

tl :: List a -> List a
tl l@(L list) = shiftLeft l

shiftLeft :: List a -> List a
shiftLeft (L list) = L (\index -> list (index + 1))

len :: List a -> Int
len list
   = len' 0 list
   where
   len' :: Int -> List a -> Int 
   len' n l@(L list)
      = case list n of
           Nothing -> n
           Just _  -> len' (n+1) (tl l)

instance Show a => Show (List a) where
   show list
      = showList 0 list
      where
      showList :: Show b => Int -> List b -> String
      showList n l@(L list)
         = case list n of
              Nothing -> " | " 
              Just x  -> show x ++ " - " ++ showList (n+1) l 

mkList :: [a] -> List a
mkList xs 
   = L $ mkList' 0 xs
   where
   mkList' n [] = \index -> Nothing
   mkList' n (x:xs) 
      = \index -> if index == n then Just x else (mkList' (n+1) xs index )
