{- found on usenet -}
module Main where

miter2 :: Double -> Double -> Int -> Int

miter2 x y maxiter =
  it x y 0 where
  it a b i =
      if   ( i >= maxiter) || ( a * a + b* b > 4.0) then i
      else it (((a + b) * (a - b)) + x) ((2.0 * a * b + y)) (i+1)

foldWhile min max step op start f =
    let { aux min val =
          if    min >= max then start
          else  op (f min) (aux (min+step) val) }
        in aux min start

mandel :: Double -> Double -> Double -> Int -> Int

mandel x y size res =
    let y_max = y + size
        step  = size / (fromIntegral res) in
        foldWhile x (x+size) step (+) 0
          (\ u -> foldWhile y y_max step (+) 0
           (\ v -> miter2 u v 150))

main = do { putStr ((show $ mandel (-2.0) (-2.0) 4.0 400) ++ "\n") }

