-- this solves the postal van problem
-- but it isn't very fast

module Main where

import System (getArgs)

main = do args <- getArgs
          let numRoads = (read $ args !! 0) :: Integer
          print_solve numRoads

{- a version that prints the solutions (very inefficient) -}
  

print_solve :: Integer -> IO ()
print_solve i 
   = putStrLn $ unlines $ map unlines $ print_sol i

print_sol :: Integer -> [[String]]
print_sol 0 = []
print_sol 1 = []
print_sol n 
   = print_abc (n-1) 0 (n-1) [] ++ print_ac (n-1) 0 (n-1) [] 

print_abc 1 m k sols
   | m == k - 1 = map ("XXX":) sols 
   | otherwise = [] 
print_abc n m k sols
   = print_a (n-1) m k newSols ++  
     print_b (n-1) m k newSols ++
     print_ac' (n-1) m k newSols ++
     print_c (n-1) m k newSols
   where
   newSols = map ("XXX":) sols 

print_ac 1 m k sols
   | m + 1 == k - 1 = map ("X X":) sols 
   | otherwise = [] 
print_ac n m k sols 
   = print_ac (n-1) l k newSols ++
     print_abc (n-1) l k newSols ++
     print_a (n-1) l k newSols ++
     print_c (n-1) l k newSols
   where
   l = m + 1
   newSols = map ("X X":) sols 

print_ac' 1 m k sols
   | m + 1 == k - 1 = map ("X X":) sols 
   | otherwise = [] 
print_ac' n m k sols 
   = print_ac' (n-1) l k newSols ++
     print_a (n-1) l k newSols ++
     print_c (n-1) l k newSols
   where
   l = m + 1
   newSols = map ("X X":) sols 

print_a 1 _ _ _ = [] 
print_a n m k sols
   = print_abc (n-1) l k newSols ++
     print_ac (n-1) l k newSols
   where 
   l = m + 2
   newSols = map ("X  ":) sols 

print_c 1 _ _ _ = [] 
print_c n m k sols
   = print_abc (n-1) l k newSols ++
     print_ac (n-1) l k newSols
   where 
   l = m + 2
   newSols = map ("  X":) sols 

print_b 1 _ _ _ = [] 
print_b n m k sols 
   = print_abc (n-1) (m + 2) k newSols
   where 
   newSols = map (" X ":) sols 

