-- the example program from the user's guide
module Main where

data Tree a = Nil | Node a (Tree a) (Tree a)
              deriving Show

treeFromList :: Ord a => [a] -> Tree a
treeFromList = foldr insertInTree Nil 

insertInTree :: Ord a => a -> Tree a -> Tree a
insertInTree x Nil = Node x Nil Nil
insertInTree x (Node y l r)
   | x > y = Node y l (insertInTree x r)
   | otherwise = Node y (insertInTree x l) r

mirror :: Tree a -> Tree a
mirror Nil = Nil
mirror (Node x l r)
   -- the bug is here my friends!
   = Node x (mirror l) (mirror l)

main :: IO ()
main = do putStrLn "Type some input:" 
          line <- getLine 
          print $ mirror $ treeFromList line
          putStrLn "The End" 
