{-------------------------------------------------------------------------------

        Copyright:              Bernie Pope 2004

        Module:                 Advice 

        Description:            wise quotes 

        Primary Authors:        Bernie Pope

-------------------------------------------------------------------------------}

{-
    This file is part of buddha.

    buddha is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    buddha is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with buddha; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

-}

module Advice 
   ( advice ) where

import IO 
import Data 
   ( DebugState (..) 
   , Config (..)
   , readGlobalState 
   , readGlobalStateConfig
   )
import IOUtils
import Directory
import Random
import List
import Control.Exception as E
import ColourString
   ( decorIOLn )

--------------------------------------------------------------------------------

advice :: IO ()
advice 
   = do width <- readGlobalStateConfig config_screenWidth 
        adviceDir <- readGlobalState state_dataDir 
        adviceAvailable <- anyAdviceAvailable adviceDir
        newline 
        tabIO $ decorIOLn "Perhaps this might help with your bug:"
        newline 
        case adviceAvailable of
           Just contents -> giveAdvice adviceDir width contents 
           Nothing -> tabIO $ putStr $ defaultAdvice
        newline
        newline

defaultAdvice :: String
defaultAdvice = "Be more careful next time."

anyAdviceAvailable :: FilePath -> IO (Maybe [FilePath])
anyAdviceAvailable adviceDir 
   = do tryContents <- E.try $ getDirectoryContents adviceDir
        let saneContents 
              = case tryContents of
                   Left _e -> []
                   Right contents -> filter (isPrefixOf "wise") contents
        -- make sure there is at least one file to read
        if saneContents == [] 
           then return Nothing
           else return $ Just saneContents 

giveAdvice :: FilePath -> Int -> [FilePath] -> IO ()
giveAdvice adviceDir width adviceContents 
   = do index <- randomIndex $ length adviceContents 
        let selectedAdvice = adviceContents !! (index - 1) 
        tryRead <- E.try $ readFile $ adviceDir ++ "/" ++ selectedAdvice
        case tryRead of
           Right advice -> printInWidth width advice
           Left _e      -> tabIO $ putStr $ defaultAdvice

randomIndex :: Int -> IO Int
randomIndex max = getStdRandom (randomR (1,max))

printInWidth :: Int -> String -> IO () 
printInWidth width str 
   = portrayAdvice (width - tabsize) (words str)

portrayAdvice :: Int -> [String] -> IO () 
portrayAdvice width words
   = tabIO $ portrayAdvice width 0 words
   where
   portrayAdvice width acc [] = return () 
   portrayAdvice width 0 (w:ws)
      | length w >= width 
           = do putStrLn w 
                tabIO $ portrayAdvice width 0 ws
   portrayAdvice width acc (w:ws) 
      | newWidth < width 
           = do putStr w  
                space 
                portrayAdvice width newWidth ws
      | otherwise 
           = do newline 
                tabIO $ portrayAdvice width 0 (w:ws)
      where
      wordLen = length w
      newWidth = acc + wordLen + 1
