{-------------------------------------------------------------------------------

        Copyright:              Bernie Pope 2004 

        Module:                 AnsiColor 

        Description:            Color combinators using ANSI escape sequences 

        Primary Authors:        Bernie Pope

-------------------------------------------------------------------------------}

{-
    This file is part of buddha.

    buddha is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    buddha is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with buddha; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

-}

module AnsiColour 
   ( Colour (..)
   , allColours
   , blackFG
   , redFG
   , greenFG
   , yellowFG
   , blueFG
   , magentaFG
   , cyanFG
   , whiteFG
   )
   where

{-
30 black foreground
31 red foreground
32 green foreground
33 yellow foreground
34 blue foreground
35 magenta foreground
36 cyan foreground
37 white foreground
40 black background
41 red background
42 green background
43 yellow background
44 blue background
45 magenta background
46 cyan background
47 white background
-}

data Colour
   = Black
   | Red
   | Green
   | Yellow
   | Blue
   | Magenta
   | Cyan
   | White
   | Default
   deriving (Enum, Eq)

allColours :: [Colour]
allColours = [Black .. Default]

instance Show Colour where
   show Black   = "black"
   show Red     = "red"
   show Green   = "green"
   show Yellow  = "yellow"
   show Blue    = "blue"
   show Magenta = "magenta"
   show Cyan    = "cyan"
   show White   = "white" 
   show Default = "default"

-- these numbers make it easy to use derived enum instances to
-- generate appropriate colour numbers from the constructors
magicFG = 30
magicBG = 40

colourFG :: Colour -> String -> String
colourFG c str
   = startCol (fromEnum c + magicFG) ++ str ++ endCol
   where
   startCol :: Int -> String
   startCol i = "\ESC[" ++ show i ++ "m"
   endCol :: String
   endCol = "\ESC[0m" 

blackFG   = colourFG Black 
redFG     = colourFG Red
greenFG   = colourFG Green
yellowFG  = colourFG Yellow
blueFG    = colourFG Blue
magentaFG = colourFG Magenta
cyanFG    = colourFG Cyan
whiteFG   = colourFG White
