{-------------------------------------------------------------------------------

        Copyright:              Bernie Pope 2004 

        Module:                 ColourString

        Description:            make coloured strings based on the colours
                                set by the user

        Primary Authors:        Bernie Pope

-------------------------------------------------------------------------------}

{-
    This file is part of buddha.

    buddha is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    buddha is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with buddha; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

-}

module ColourString 
   ( promptIOLn
   , promptIO
   , promptColour 
   , valueIOLn
   , valueIO
   , nameIOLn
   , nameIO
   , decorIOLn
   , decorIO
   , decorColour
   , alertIOLn
   , alertIO
   )
   where

import AnsiColour

import Data
   ( Config (..)
   , readGlobalStateConfig
   )

--------------------------------------------------------------------------------

promptColour :: String -> IO String
promptColour str
   = do wantColour <- readGlobalStateConfig config_colours
        if wantColour
           then do promptCol <- readGlobalStateConfig config_promptColour
                   return $ colourString promptCol str
           else return str

promptIOLn :: String -> IO ()
promptIOLn str = putStrLn =<< promptColour str

promptIO :: String -> IO ()
promptIO str = putStr =<< promptColour str

decorColour :: String -> IO String
decorColour str
   = do wantColour <- readGlobalStateConfig config_colours
        if wantColour
           then do decorCol <- readGlobalStateConfig config_decorColour
                   return $ colourString decorCol str
           else return str

decorIOLn :: String -> IO ()
decorIOLn str = putStrLn =<< decorColour str

decorIO :: String -> IO ()
decorIO str = putStr =<< decorColour str

name :: String -> IO String
name str
   = do wantColour <- readGlobalStateConfig config_colours
        if wantColour
           then do nameCol <- readGlobalStateConfig config_nameColour
                   return $ colourString nameCol str
           else return str

nameIOLn :: String -> IO ()
nameIOLn str = putStrLn =<< name str

nameIO :: String -> IO ()
nameIO str = putStr =<< name str

value :: String -> IO String
value str
   = do wantColour <- readGlobalStateConfig config_colours
        if wantColour
           then do valueCol <- readGlobalStateConfig config_valueColour
                   return $ colourString valueCol str
           else return str

valueIOLn :: String -> IO ()
valueIOLn str = putStrLn =<< value str

valueIO :: String -> IO ()
valueIO str = putStr =<< value str

alert :: String -> IO String
alert str
   = do wantColour <- readGlobalStateConfig config_colours
        if wantColour 
           then do alertCol <- readGlobalStateConfig config_alertColour
                   return $ colourString alertCol str
           else return str 

alertIOLn :: String -> IO ()
alertIOLn str = putStrLn =<< alert str

alertIO :: String -> IO ()
alertIO str = putStr =<< alert str

colourString :: Colour -> String -> String
colourString Black   = blackFG
colourString Red     = redFG
colourString Green   = greenFG
colourString Yellow  = yellowFG
colourString Blue    = blueFG
colourString Magenta = magentaFG
colourString Cyan    = cyanFG
colourString White   = whiteFG
colourString Default = id
