{-------------------------------------------------------------------------------

        Copyright:              Bernie Pope 2004

        Module:                 Tables 

        Description:            Encoding of higher order values (aka functions). 

        Primary Authors:        Bernie Pope

                                At the moment we only support encoding of
                                functions of arity upto 10. It is easy to add
                                more, and we made do so if the need arises. 

-------------------------------------------------------------------------------}

module FunEncode 
   ( F (F0, F1, F2)
   , app
   , f1, f2, f3, f4, f5, f6, f7, f8, f9, f10
   , f11, f12, f13, f14, f15, f16, f17, f18, f19, f20
   , fu1, fu2, fu3, fu4, fu5, fu6, fu7, fu8, fu9, fu10
   , fu11, fu12, fu13, fu14, fu15, fu16, fu17, fu18, fu19, fu20
   , fio
   ) where

import Meta
   ( Val (V) )

import Tables
   ( getFunCount
   , updateFunTable
   )

--------------------------------------------------------------------------------

-- encoding of a higher-order function (a function which is an argument or
-- result of another function)
data F a b 
   = F0 (a -> b)  -- the function itself
        Int       -- index into the function table that records all applications
                  -- of this function
   | F1 (a -> b)  -- not recorded function
   | F2 (a -> b)  -- an IO function

-- how to apply an encoded function
app :: F a b -> a -> b
app (F0 f _) = f
app (F1 f)   = f
app (F2 f)   = f

-- construct encodings for functions of a given arity

f1 :: (a -> b) -> F a b
f1 g  = getFunCount $ \c -> F0 (\x -> updateFunTable c (V x) $ g x) c
f2 :: (a -> b -> c) -> F a (F b c)
f2 g  = getFunCount $ \c -> F0 (\x -> updateFunTable c (V x) $ f1 (g x)) c
f3 :: (a -> b -> c -> d) -> F a (F b (F c d))
f3 g  = getFunCount $ \c -> F0 (\x -> updateFunTable c (V x) $ f2 (g x)) c
f4 g  = getFunCount $ \c -> F0 (\x -> updateFunTable c (V x) $ f3 (g x)) c
f5 g  = getFunCount $ \c -> F0 (\x -> updateFunTable c (V x) $ f4 (g x)) c
f6 g  = getFunCount $ \c -> F0 (\x -> updateFunTable c (V x) $ f5 (g x)) c
f7 g  = getFunCount $ \c -> F0 (\x -> updateFunTable c (V x) $ f6 (g x)) c
f8 g  = getFunCount $ \c -> F0 (\x -> updateFunTable c (V x) $ f7 (g x)) c
f9 g  = getFunCount $ \c -> F0 (\x -> updateFunTable c (V x) $ f8 (g x)) c
f10 g = getFunCount $ \c -> F0 (\x -> updateFunTable c (V x) $ f9 (g x)) c
f11 g = getFunCount $ \c -> F0 (\x -> updateFunTable c (V x) $ f10 (g x)) c
f12 g = getFunCount $ \c -> F0 (\x -> updateFunTable c (V x) $ f11 (g x)) c
f13 g = getFunCount $ \c -> F0 (\x -> updateFunTable c (V x) $ f12 (g x)) c
f14 g = getFunCount $ \c -> F0 (\x -> updateFunTable c (V x) $ f13 (g x)) c
f15 g = getFunCount $ \c -> F0 (\x -> updateFunTable c (V x) $ f14 (g x)) c
f16 g = getFunCount $ \c -> F0 (\x -> updateFunTable c (V x) $ f15 (g x)) c
f17 g = getFunCount $ \c -> F0 (\x -> updateFunTable c (V x) $ f16 (g x)) c
f18 g = getFunCount $ \c -> F0 (\x -> updateFunTable c (V x) $ f17 (g x)) c
f19 g = getFunCount $ \c -> F0 (\x -> updateFunTable c (V x) $ f18 (g x)) c
f20 g = getFunCount $ \c -> F0 (\x -> updateFunTable c (V x) $ f19 (g x)) c
-- keep going here if you like

-- construct encodings for functions of a given arity
-- these versions do not record anything in the function table
-- thus they are cheap - but do not produce anything which can be
-- printed when debugging
-- the fu name means function "u"nrecorded
-- short names are good here because they appear extensively in 
-- the transformed program

fu1 :: (a -> b) -> F a b
fu1 g  = F1 g 
fu2 :: (a -> b -> c) -> F a (F b c)
fu2 g  = F1 (\x -> fu1 (g x)) 
fu3 g  = F1 (\x -> fu2 (g x)) 
fu4 g  = F1 (\x -> fu3 (g x)) 
fu5 g  = F1 (\x -> fu4 (g x)) 
fu6 g  = F1 (\x -> fu5 (g x)) 
fu7 g  = F1 (\x -> fu6 (g x)) 
fu8 g  = F1 (\x -> fu7 (g x)) 
fu9 g  = F1 (\x -> fu8 (g x)) 
fu10 g = F1 (\x -> fu9 (g x)) 
fu11 g = F1 (\x -> fu10 (g x)) 
fu12 g = F1 (\x -> fu11 (g x)) 
fu13 g = F1 (\x -> fu12 (g x)) 
fu14 g = F1 (\x -> fu13 (g x)) 
fu15 g = F1 (\x -> fu14 (g x)) 
fu16 g = F1 (\x -> fu15 (g x)) 
fu17 g = F1 (\x -> fu16 (g x)) 
fu18 g = F1 (\x -> fu17 (g x)) 
fu19 g = F1 (\x -> fu18 (g x)) 
fu20 g = F1 (\x -> fu19 (g x)) 
-- keep going here if you like

-- for encoding the IO monad 
fio :: (a -> b) -> F a b
fio g = F2 g
